<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-sm-4">
            <div class="card">
                <div class="card-body">
                    <p class="p-2">Manager Name: <?php echo e($reseller->name); ?></p>
                    <p class="p-2" style="font-size:30px;font-weight:bold">Balance:
                        <?php echo e($reseller->balance[0]['amount'] ?? 0); ?></p>
                    <hr>

                    <div class="form-group">
                        <label for="amount">Amount</label>
                        <input type="number" class="form-control" id="amount" name="amount"
                            min="<?php echo e(intval($min_recharge_amount)); ?>" placeholder="Enter Amount">
                    </div>

                    <?php if(checkSettings('bkash-reseller-recharge') == 'enable'): ?>
                        <button class="btn btn-danger" id="bkash">Bkash</button>
                    <?php endif; ?>
                    <?php if(checkSettings('upay-reseller-recharge') == 'enable'): ?>
                        <button class="btn btn-danger" id="upay">Upay</button>
                    <?php endif; ?>
                    <?php if(checkSettings('nagad-reseller-recharge') == 'enable'): ?>
                        <button class="btn btn-danger" id="nagad">Nagad</button>
                    <?php endif; ?>

                    <?php
                        $buttons = collect(json_decode(siteinfo()->payment_button));
                        $ssl_image_btn = $buttons->where('type', 'ssl_img')->first();
                    ?>
                    <?php if(checkSettings('ssl-reseller-recharge') == 'enable'): ?>
                        <button type="button" id="paySSL" class="btn ">
                            <img style="height:50px; border-radius:5px;padding:5px;"
                                src="<?php if(!empty($ssl_image_btn)): ?> <?php echo e(asset('storage/company/' . $ssl_image_btn->value)); ?> <?php else: ?> visa.png <?php endif; ?>"
                                alt="">
                        </button>

                        <button style="display: none" class="hidden btn btn-primary btn-lg btn-block" id="sslczPayBtn"
                            token="if you have any token validation"
                            postdata="your javascript arrays or objects which requires in backend"
                            order="If you already have the transaction generated for current order"
                            endpoint="<?php echo e(route('resellerPayViaAjax')); ?>"> Pay Now
                        </button>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="col-sm-8">
            <div class="card">
                <div class="card-body">
                    <p class="p-2">Manager Recharge History </p>

                    <div class="form-group">
                        <div class="table-responsive">
                            <table class="table table-borderd table-striped">
                                <thead class="bg-blue-50">
                                    <tr>

                                        <th>
                                            Date
                                        </th>

                                        <th class="text-right">
                                            Recharge Amount
                                        </th>

                                        <th class="text-right">
                                            After Recharge Balance
                                        </th>
                                        <?php if(checkSettings('reseller-recharge-paid-option') == 'enable'): ?>
                                            <th class="text-right">Paid Amount</th>
                                        <?php endif; ?>

                                        <th>
                                            Remarks
                                        </th>
                                        <th>
                                            Recharge By
                                        </th>
                                        <th>

                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="
                                        bg-white divide-y divide-gray-200">
                                    <?php $__currentLoopData = $rechargeList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>

                                            <td>
                                                <?php echo e(date('d-M-Y h:i:sa', strtotime($r->created_at))); ?>

                                            </td>



                                            <td class="text-right">
                                                <?php echo e($r->amount); ?>

                                            </td>


                                            <td class="text-right">
                                                <?php echo e($r->after_recharge_balance); ?>

                                            </td>
                                            <?php if(checkSettings('reseller-recharge-paid-option') == 'enable'): ?>
                                                <td class="text-right"><?php echo e($r->paid_amount); ?></td>
                                            <?php endif; ?>

                                            <td>
                                                <?php echo e($r->remarks); ?>

                                            </td>
                                            <td>
                                                <?php echo e($r->user->name ?? ''); ?>

                                            </td>


                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <tr class="bg-info">
                                        <td class="text-right">Total Recharge: </td>
                                        <td class="text-right"><?php echo e($rechargeList->sum('amount')); ?></td>
                                        <?php if(checkSettings('reseller-recharge-paid-option') == 'enable'): ?>
                                            <td class="text-right">Total Paid: </td>
                                            <td class="text-right"><?php echo e($rechargeList->sum('paid_amount')); ?></td>
                                        <?php endif; ?>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>





                    </div>
                </div>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready(function() {

            $('#upay').on('click', function() {
                payment('upay');
            });

            $('#bkash').on('click', function() {
                payment('bkash');
            });
            $('#nagad').on('click', function() {
                payment('nagad');
            });

            function setCookie(cname, cvalue, exdays) {
                const d = new Date();
                d.setTime(d.getTime() + (exdays * 60 * 1000));
                let expires = "expires=" + d.toUTCString();
                document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
            }

            function deleteCookie(cname) {
                document.cookie = cname + "=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;";
            }

            function payment(payment_method) {
                // $('#processing').show();
                let minAmount = <?php echo e($min_recharge_amount); ?>;
                let enteredAmount = parseFloat($('#amount').val());
                if (enteredAmount < minAmount) {
                    alert("Amount should not be less than " + minAmount);
                    return false;
                }
                console.log('comes payment');


                $.ajax({
                    url: "<?php echo e(route('onlineManagerRechargeExecute')); ?>",
                    type: "POST",
                    data: {
                        amount: enteredAmount,
                        _token: "<?php echo e(csrf_token()); ?>",
                        payment_method: payment_method,
                        reseller_id: <?php echo e($reseller->id); ?>,
                    },
                    success: function(data) {
                        $('#processing').hide();

                        if (payment_method == 'upay') {
                            if (data.status == 'error') {
                                toastr.error(data.message);
                            } else if (data.message == "Merchant Payment Init Success") {

                                window.location.href = data.data.gateway_url;
                            }
                        } else if (payment_method == 'bkash') {
                            if (data.status == 'error') {


                                toastr.error(data.message);
                            } else if (data.statusMessage == "Successful") {

                                setCookie('online_reseller_recharge_reseller_id', data.reseller_id, 5);
                                setCookie('online_reseller_recharge_token_id', data.token, 5);
                                window.location.href = data.bkashURL;
                            }
                        } else if (payment_method == 'nagad') {
                            if (data.status == 'error') {
                                toastr.error(data.message);
                            } else if (data.status == "success") {
                                window.location.href = data.message;
                            }
                        }


                    },
                    
                    error: function(xhr, status, error) { // Add error handler
                        console.log('Error:', xhr.responseText);
                    }
                });
            }
        });
    </script>

    <?php if(checkSettings('ssl-commerz-show') == 'enable'): ?>
        <script>
            var obj = {};
            $('#paySSL').on('click', function() {

                let minAmount = <?php echo e($min_recharge_amount); ?>;
                let enteredAmount = parseFloat($('#amount').val());

                obj.minAmount = <?php echo e($min_recharge_amount); ?>;
                obj.enteredAmount = parseFloat($('#amount').val());
                obj.reseller_id = <?php echo e($reseller->id); ?>;

                if (enteredAmount < minAmount) {
                    alert("Amount should not be less than " + minAmount);
                    return false;
                }

                if ($('#amount').val() != '') {
                    console.log(obj);
                    $('#sslczPayBtn').prop('postdata', obj);
                    $('#sslczPayBtn').click();
                } else {
                    toastr.error('Amount is required');
                }
            });
        </script>

        <?php if(checkSettings('ssl-commerz-live') == 'enable'): ?>
            <script>
                (function(window, document) {
                    var loader = function() {
                        var script = document.createElement("script"),
                            tag = document.getElementsByTagName("script")[0];
                        script.src = "https://seamless-epay.sslcommerz.com/embed.min.js?" + Math.random().toString(36)
                            .substring(7);
                        tag.parentNode.insertBefore(script, tag);
                    };
                    window.addEventListener ? window.addEventListener("load", loader, false) : window.attachEvent("onload",
                        loader);
                })(window, document);
            </script>
        <?php else: ?>
            <script>
                (function(window, document) {
                    var loader = function() {
                        var script = document.createElement("script"),
                            tag = document.getElementsByTagName("script")[0];
                        script.src = "https://sandbox.sslcommerz.com/embed.min.js?" + Math.random().toString(36).substring(
                            7);
                        tag.parentNode.insertBefore(script, tag);
                    };
                    window.addEventListener ? window.addEventListener("load", loader, false) : window.attachEvent("onload",
                        loader);
                })(window, document);
            </script>
        <?php endif; ?>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/friendsdigital/radius-circle/resources/views/reseller/resellerRechargeOnline.blade.php ENDPATH**/ ?>