<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRadiusLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(checkSettings('connect_second_data_base') == "enable"){

            Schema::connection('mysql2')->create('radius_logs', function (Blueprint $table) {
                $table->id();
                $table->string('session_id');
                $table->string('username');
                $table->string('ip_address')->nullable();
                $table->string('mac_address')->nullable();
                $table->decimal('uploaded', 20, 2)->default(0);
                $table->decimal('downloaded', 20, 2)->default(0);
                $table->dateTime('session_start_time');
                $table->dateTime('session_end_time')->nullable();
                $table->string("last_disconnect_reason")->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('radius_logs');
    }
}
