<?php

namespace Database\Seeders;

use App\Models\Permission;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AdminPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
       $data= [
            'user-registration',
            'password-change',
            'user-logout',
            'assign-permission',
            'assign-permission-role',
            'assign-role',
            'assign-user-role',
            'user_index',
            'permission_create',
            'permission_store',
            'permission_edit',
            'permission_update',
            'permission_index',
            'permission_destroy',
            'role_create',
            'role_store',
            'role_edit',
            'role_update',
            'role_index',
            'role_destroy',
            'pop_box',
            'box_switch',
            'pop_index',
            'pop_edit',
            'pop_update',
            'pop_destroy',
            'box_index',
            'box_create',
            'box_store',
            'box_edit',
            'box_update',
            'box_destroy',
            'switch_create',
            'switch_store',
            'switch_index',
            'connection-request',
            'connection-request-list',
            'port-assignment',
            'customer-support',
            'close-token',
            'TokenByPOP',
            'assign-token',
            'customer-info',
            'customer-summary',
            'customer-contact-details',
            'customer-technical-details',
            'customer-token-details',
            'TokenById',
            'pop-name',
            'token-category',
            'token-code',
            'connection-history',
            'manage-connection',
            'customer-accounts',
            'customer-rating',
            'new-token',
            'update-token',
            'delete-token',
            'new_connection_edit',
            'new_connection_update',
            'home',
            'admin-token-close',
            'support-token-close',
            'accounts-token-close',
            'package-id',
            'monthly-report',
            'token-report',
            'token-search',
            'employee_create',
            'employee_store',
            'employee_edit',
            'employee_update',
            'employee_index',
            'employee_destroy',
            'nc-report',
            'requisition_create',
            'requisition_store',
            'money-receipt-entry',
            'money-receipt-entry-admin',
            'discount',
            'ip-bill',
            'get-customer-info',
            'payment-report',
            'billing-report',
            'bill-sheet',
            'print-bill',
            'bill-sheet-pdf',
            'generate-bill',
            'generate-other-bill',
            'single-discount',
            'inventory-transaction-report',
            'account-statement',
            'connection-search',
            'corporate-money-receipt-entry',
            'get-corporate-customer-info',
            'corporate-money-receipt-entry-admin',
            'generate-corporate-bill',
            'generate-corporate-other-bill',
            'corporate-account-statement',
            'corporate-print-bill',
            'corporate-customer-data_index',
            'corporate-customer-data_create',
            'corporate-customer-data_store',
            'corporate-customer-data_edit',
            'corporate-customer-data_update',
            'corporate-customer-data_destroy',
            'corporate-close-customer',
            'reseller-recharge-report',
            'unit_create',
            'unit_store',
            'unit_index',
            'unit_edit',
            'unit_update',
            'unit_destroy',
            'inventory-group_index',
            'inventory-group_create',
            'inventory-group_store',
            'inventory-group_edit',
            'inventory-group_update',
            'inventory-group_destroy',
            'inventory_edit',
            'inventory_create',
            'inventory_store',
            'inventory_update',
            'inventory_index',
            'inventory_destroy',
            'inventory-in_create',
            'inventory-in_store',
            'inventory-in_destroy',
            'inventory-in_index',
            'get-inventory-list',
            'requisition_index',
            'requisition_edit',
            'requisition_update',
            'requisition_destroy',
            'requisition_approve',
            'requisition_pending',
            'requisition_approved',
            'requisition_delivery',
            'requisition_show',
            'requisition_print',
            'supplier_index',
            'supplier_create',
            'supplier_store',
            'supplier_edit',
            'supplier_update',
            'supplier_destroy',
            'package-permission',
            'package_create',
            'package_store',
            'package_index',
            'package_edit',
            'package_update',
            'package_destroy',
            'pop_create',
            'pop_store',
            'pop_exception',
            'reseller_index',
            'reseller_create',
            'reseller_store',
            'reseller_edit',
            'reseller_update',
            'reseller-recharge',
            'mikrotik_create',
            'mikrotik_store',
            'mikrotik_index',
            'mikrotik_edit',
            'mikrotik_update',
            'assign-package-permission',
            'package-permission-form',
            'pop-exception_destroy',
            'company_edit',
            'company_update',
            'company_index',
            'refresh',
            'refresh-super',
            'assign-user-reseller',
            'assign-reseller',
            'mac-customer_index',
            'mac-customer_create',
            'mac-customer_store',
            'mac-customer_edit',
            'mac-customer_update',
            'mac-customer_destroy',
            'reseller-super',
            'get-username-availability',
            'get-expirity-n-cost',
            'customer_show',
            'login-attempts',
            'log-history',
            'get-expirity-n-cost-for-recharge',
            'changeBillCycle',
            'newBillCycle',
            'changePackage',
            'newPackage',
            'clientSummary',
            'onlineUser',
            'onlineUserDisconnection',
            'ledger_create',
            'ledger_store',
            'ledger_edit',
            'ledger_update',
            'ledger_destroy',
            'ledger_index',
            'payment_create',
            'payment_store',
            'payment_index',
            'payment_edit',
            'payment_update',
            'payment_destroy',
            'receive_create',
            'receive_store',
            'receive_index',
            'receive_edit',
            'receive_update',
            'receive_destroy',
            'contra_create',
            'contra_store',
            'contra_index',
            'contra_edit',
            'contra_update',
            'contra_destroy',
            'journal_create',
            'journal_store',
            'journal_edit',
            'journal_update',
            'journal_destroy',
            'journal_index',
            'account-group_create',
            'account-group_store',
            'account-group_index',
            'account-group_edit',
            'account-group_update',
            'account-group_destroy',
            'ledger_show',
            'ledger-report',
            'ledger-name',
            'profit_n_loss',
            'balance-sheet',
            'reseller-balance-log-report',
            'new-connection-search',
            'customer-search-report',
            'get-pop-list',
            'assign-user-pop',
            'assign-pop',
            'pop-recharge',
            'sub-package-permission-form',
            'sub-package-permission',
            'get-package-list',
            'sub-package_create',
            'sub-package_store',
            'sub-package_edit',
            'sub-package_update',
            'sub-package_index',
            'sub-package_destroy',
            'get-pop-package-list',
            'money-receipt-destroy',
            'corporate-money-receipt-destroy',
            'sub-reseller-recharge-report',
            'sub-reseller-balance-log-report',
            'mac-customer-ip',
            'customer-due',
            'customer-recharge',
            'money-receipt-search',
            'user_edit',
            'user_update',
            'single-discount-corporate',
            'customer-recharge-batch',
            'mac-customer-close',
            'password-reset',
            'onlineUserSessionDisconnection',
            'admin-password-reset',
            'admin-password-reset-post',
            'get-pop-list-for-edit',
            'manual-sub-package-change',
            'mac-customer_show',
            'login-attempts-all',
            'export-customer-list-excel',
            'reseller-report',
            'corporate-connection-request',
            'corporate-connection-request-list',
            'corporate-customer-support',
            'corporate-customer-info',
            'corporate-customer-summary',
            'corporate-customer-contact-details',
            'corporate-customer-technical-details',
            'corporate-customer-token-details',
            'corporate-new-token',
            'corporate-update-token',
            'corporate-delete-token',
            'corporate-token-category',
            'corporate-token-code',
            'corporate-manage-connection',
            'CorporateTokenById',
            'close-corporate-token',
            'manageCorporateConnection',
            'corporate-customer-accounts',
            'corporate-connection-history',
            'assign-corporate-token',
            'printCorporateToken', 'web',
            'downloadCorporateToken',
            'excel',
            'customer-list-for-BTRC',
            'last-month-report',
            'comment-token',
            'new_corporate_connection_edit',
            'new_corporate_connection_update',
            'income-section',
            'expense-section',
            'bill-collection',
            'other-income',
            'account-head',
            'expense-entry',
            'reseller-menu-view',
            'customer-menu-view',
            'account-menu-view',
            'report-menu-view',
            'admin-menu-view',
            'new-customer-approve',
            'pending-customer',
            'customer-deactivated',
            'deactivated-customer_index',
            'newjoin',
            'oflineUser',
            'id-enable',
            'id-disable',
            'customer-delete',
            'customer-reactivate',
            'income-report',
            'expense-report',
            'extra',
            'income-head',
            'income-entry',
            'expense-head',
            'ip-pool',
            'show-dashboard',
            'sub-pack-commission',
            'pack-commission',
            'view-commission',
            'sub-reseller-view-commission',
            'expire-customer',
            'disable-customer',
            'active-customer',
            'fund-transfer',
            'show-mother-package',
            'show-motherpackage-rate',
            'cash-in-hand',
            'payment-discount',
            'show-sub-package',
            'show-sub-package-rate',
            'can-close',
            'reseller_area_index',
            'reseller_area_create',
            'can-open',
            'paid-otc-report',
            'due-otc-report',
            'pop-disable',
            'search-by-package-name',
            'add-otc',
            'company-info',
            'sms_gateway_index',
            'sms_gateway_list',
            'sms_balance',
            'bkash-recharge',
            'extend-temporary-dedline',
            'approve-local-customer',
            'parmanent-discount',
            'send-batch-sms',
            'sms-log',
            'delete-generated-bill',
            'bulk-date-extended',
            'otc-report',
            'customer-export',
            'payment-method',
            'commission-in-hand',
            'due-customer-list',
            'token-dashboard',
            'bill-extended-customers',
            'pop-deactive',
            'pop-close',
            'edit-mother-package',
            'bill-generate-report',
            'dashboard-billing-info',
            'dashboard-counter',
            'sms-setting',
            'advanced-balance-list',
            'client-username-edit',
       ];

       foreach ($data as $item) {
            $permission = Permission::where('name', $item)->first();
            if($permission) {

                $role_permissions = DB::table('role_has_permissions')->where('permission_id', $permission->id)->where('role_id', 1)->first();
                if(!$role_permissions) {
                    DB::table('role_has_permissions')->insert([
                        'permission_id' => $permission->id,
                        'role_id' => 1,
                    ]);
                }

            }
       }
    }
}
