@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">

            <form action="" id="search" class="form">
                <div class="row">
                    <div class="col-md-4 col-sm-4 col-xs-4">
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                Manager Name
                            </label>
                            <select name="reseller" id="reseller" class="form-control select2 form-control-sm" required>
                                <option value="">ALL Manager</option>
                                @foreach (userResellers() as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-4 col-xs-4">
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                POP Name
                            </label>
                            <select name="pop" id="pop" class="form-control select2 form-control-sm" required>
                                <option value=""> ALL POP</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="form-group mt-2 float-right">
                    <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                            class="fa fa-search"></i> Update</button>
                    <button class="btn btn-info" type="reset" id="reset">Reset</button>
                </div>
            </form>

            <div id="result"></div>

        </div>
    </div>
@endsection

@section('ajax')
    <script type="text/javascript">
        $(function() {

            $('#reset').click(function() {
                $('#result').html('');
            });

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $('body').prepend('<div id="loading">Loading.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('popWiseRadClientUpdate') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $('#loading').remove();
                    }
                });
            });

        });
    </script>
@endsection
