@can('dashboard-billing-info')
    @can('pop-wise-dashboard-report')
        <section class="bill-collection-area bg-white pt-2 px-4 mt-2 mb-2 pb-2">
            <h4 class="text-center my-2">Report Pop/Sub Manager wise of Monthly Generated Bill Collection {{ date('M') }}
                {{ date('Y') }}</h4>
            <table class="table table-hover table-responsive-lg">
                <thead>
                    <tr>
                        <th scope="col" class="h6">Pop/Sub Manager</th>
                        <th scope="col" class="h6">Bill Client</th>
                        <th scope="col" class="h6 text-right">Bill Amount</th>
                        <th scope="col" class="h6">Received Client</th>
                        <th scope="col" class="h6 text-right">Received Amount</th>
                        <th scope="col" class="h6 text-right">Advanced Adjustment</th>
                        <th scope="col" class="h6">Collection(%)</th>
                        <th scope="col" class="h6">Dues Clients</th>
                        <th scope="col" class="h6 text-right">Dues Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $dueClients = 0;
                        $dueAmounts = 0;
                        $clientscount = 0;
                        $totalAmounts = 0;
                        $totalAdjustment = 0;
                    @endphp

                    @foreach ($monthlyCount as $item)
                        @foreach ($item->pops as $pop)
                            <tr>
                                <td class="h6">
                                    {{ $pop->popname }}
                                </td>
                                <td class="h6">
                                    @php
                                        $sum = 0;
                                        $sum2 = 0;
                                        
                                        foreach ($pop->clients as $client) {
                                            $sum += $client->generatedBillNow->count();
                                            foreach ($client->generatedBillNow as $billgenerate) {
                                                $sum2 += $billgenerate->bill_amount;
                                            }
                                        }
                                        
                                    @endphp

                                    {{ $sum }}

                                </td>
                                {{-- bill amount --}}
                                <td class="h6 text-right">
                                    <span class="bg-danger py-1 px-3 rounded text-right">
                                        {{ $sum2 }}
                                    </span>
                                </td>
                                {{-- received id --}}
                                <td class="h6">
                                    {{ $popWiseCount[$pop->id]['tcount'] }}
                                </td>

                                {{-- received amount --}}
                                <td class="h6 text-right">
                                    @if ($popWiseCount[$pop->id]['total'] != null)
                                        {{ $popWiseCount[$pop->id]['total'] }}
                                    @else
                                        0
                                    @endif
                                </td>

                                <td class="h6 text-right">

                                    @php
                                        $adjust = 0;
                                        
                                        foreach ($pop->clients as $client) {
                                            foreach ($client->generatedBillNow as $billgenerate) {
                                                if ($billgenerate->due_amount <= 0) {
                                                    $adjust += $billgenerate->bill_amount;
                                                }
                                            }
                                        }
                                        
                                    @endphp

                                    {{ $adjust }}

                                </td>
                                {{-- col % --}}
                                <td class="h6">
                                    <span class="text-success">
                                        @if ($sum2 != 0)
                                            {{ number_format(($popWiseCount[$pop->id]['total'] * 100) / $sum2, 2) }}
                                            %
                                        @else
                                            0 %
                                        @endif
                                    </span>
                                </td>

                                <td class="h6">
                                    {{ $sum - $popWiseCount[$pop->id]['tcount'] }}
                                </td>

                                <td class="h6 text-right">
                                    {{ $sum2 - $popWiseCount[$pop->id]['total'] }}
                                </td>


                                @php
                                    $due = $sum - $popWiseCount[$pop->id]['tcount'];
                                    $dueClients += $due;
                                    $amounts = $sum2 - $popWiseCount[$pop->id]['total'];
                                    $dueAmounts += $amounts;
                                    $clientscount += $sum;
                                    $totalAmounts += $sum2;
                                    $totalAdjustment += $adjust;
                                    
                                @endphp


                            </tr>
                        @endforeach
                    @endforeach

                    @php
                        
                        $tcountSum = 0;
                        $totalSum = 0;
                        
                        foreach ($popWiseCount as $key => $value) {
                            $tcountSum += $value['tcount'];
                            $totalSum += $value['total'];
                        }
                        
                    @endphp

                    <tr class="bg-gray">
                        <td class="h6">Total</td>
                        <td class="h6">{{ $clientscount }}</td>
                        <td class="h6 text-right">{{ $totalAmounts }}</td>
                        <td class="h6">{{ $tcountSum }}</td>
                        <td class="h6 text-right">{{ $totalSum }}</td>
                        <td class="h6 text-right">{{ $totalAdjustment }}</td>
                        <td class="h6">
                            <span class="text-default">
                                @if ($totalAmounts != 0)
                                    {{ number_format(($totalSum * 100) / $totalAmounts, 2) }} %
                                @else
                                    0%
                                @endif
                            </span>

                        </td>
                        <td class="h6">{{ $dueClients }}</td>

                        <td class="h6 text-right">
                            <span class="text-default">
                                {{ $dueAmounts - $totalAdjustment }}
                            </span>
                        </td>

                    </tr>
                </tbody>
            </table>
        </section>
        @if (checkSettings('new_customer_billing_report') == 'enable')
            <section class="bill-collection-area bg-white pt-2 px-4 mt-2 mb-2 pb-2">
                <h4 class="text-center my-2">Report of New Customer, Package & Billing Cycle Change Bill Collection
                    {{ date('M') }} {{ date('Y') }}</h4>
                <table class="table table-hover table-responsive-lg">
                    <thead>
                        <tr>
                            <th scope="col" class="h6">Manager</th>
                            <th scope="col" class="h6 text-right">Bill Amount</th>
                            <th scope="col" class="h6 text-right">Received Amount</th>
                            <th scope="col" class="h6 text-right">Advanced Adjustment</th>
                            <th scope="col" class="h6">Collection(%)</th>
                            <th scope="col" class="h6 text-right">Dues Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            
                            $otherDueAmounts = 0;
                            $clientscount = 0;
                            $otherTotalAmounts = 0;
                            $totalAdjustment = 0;
                        @endphp

                        @foreach ($monthlyOthersCollection as $item)
                            @foreach ($item->pops as $pop)
                                <tr>
                                    <td class="h6">
                                        {{ $pop->popname }}
                                    </td>

                                    {{-- billed clients --}}
                                    <td class="h6 text-right">
                                        @php
                                            
                                            $sum = 0;
                                            
                                            // foreach ($item->pops as $pop) {
                                            foreach ($pop->clients as $client) {
                                                foreach ($client->generatedBillOther as $billgenerate) {
                                                    $sum += $billgenerate->bill_amount;
                                                }
                                            }
                                            // }
                                        @endphp
                                        <span class="bg-danger py-1 px-3 rounded  text-right">
                                            {{ $sum }}</span>

                                    </td>
                                    {{-- bill amount --}}
                                    <td class="h6 text-right">

                                        @if ($popWiseOtherCollection[$pop->id]['total'] != null)
                                            {{ $popWiseOtherCollection[$pop->id]['total'] }}
                                        @else
                                            0
                                        @endif

                                    </td>

                                    <td class="h6 text-right">

                                        @php
                                            $adjust = 0;
                                            
                                            // foreach ($item->pops as $pop) {
                                            foreach ($pop->clients as $client) {
                                                foreach ($client->generatedBillOther as $billgenerate) {
                                                    if ($billgenerate->due_amount <= 0) {
                                                        $adjust += $billgenerate->bill_amount;
                                                    }
                                                }
                                            }
                                            // }
                                        @endphp

                                        {{ $adjust }}

                                    </td>
                                    {{-- collection --}}
                                    <td class="h6">
                                        <span class="text-success">
                                            @if ($sum != 0)
                                                {{ number_format((($popWiseOtherCollection[$pop->id]['total'] + $adjust) * 100) / $sum, 2) }}
                                                %
                                            @else
                                                0 %
                                            @endif
                                        </span>
                                    </td>

                                    {{-- due amount --}}
                                    <td class="h6 text-right">
                                        <span class="text-primary">
                                            {{ $sum - $popWiseOtherCollection[$pop->id]['total'] - $adjust }}
                                        </span>
                                    </td>

                                    @php
                                        
                                        $amounts = $sum - $popWiseOtherCollection[$pop->id]['total'];
                                        $otherDueAmounts += $amounts;
                                        $otherTotalAmounts += $sum;
                                        $totalAdjustment += $adjust;
                                    @endphp



                                </tr>
                            @endforeach
                        @endforeach

                        <tr class="bg-gray">

                            @php
                                
                                $otherTotalSum = 0;
                                
                                foreach ($popWiseOtherCollection as $key => $value) {
                                    $otherTotalSum += $value['total'];
                                }
                                
                            @endphp
                            <td class="h6">Total</td>
                            <td class="h6 text-right">{{ $otherTotalAmounts }}</td>
                            <td class="h6 text-right">{{ $otherTotalSum }}</td>
                            <td class="h6 text-right">{{ $totalAdjustment }}</td>
                            <td class="h6">
                                @if ($otherTotalAmounts != 0)
                                    {{ number_format((($otherTotalSum + $totalAdjustment) * 100) / $otherTotalAmounts, 2) }} %
                                @else
                                    0%
                                @endif

                            </td>
                            <td class="h6 text-right">{{ $otherDueAmounts - $totalAdjustment }}</td>

                        </tr>
                    </tbody>
                </table>
            </section>
        @endif

    @endcan
@endcan
