<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AddUniqueIdToResellerBalanceLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Step 1: Add the uniqueId column (nullable temporarily)
        Schema::table('reselle_balance_log_reports', function (Blueprint $table) {
            $table->string('uniqueId')->nullable(); // No need to add unique() here
        });

        // Step 2: Update uniqueId with id values
        DB::statement('UPDATE reselle_balance_log_reports SET uniqueId = id');

        // Step 3: Add the unique constraint after the values are set
        Schema::table('reselle_balance_log_reports', function (Blueprint $table) {
            $table->unique('uniqueId');
        });
    }

    public function down()
    {
        // Drop the uniqueId column in the down method
        Schema::table('reselle_balance_log_reports', function (Blueprint $table) {
            $table->dropUnique(['uniqueId']); // Drop the unique constraint
            $table->dropColumn('uniqueId');
        });
    }

}
