import { createSlice } from "@reduxjs/toolkit";

const initialState = {
    startNode: null,
    endNode: null,
    coordinates: [],
    drawOnMap: false,
};

const reducers = {
    addStartNode(state, action) {
        state.startNode = action.payload;
        return state;
    },
    addEndNode(state, action) {
        state.endNode = action.payload;
        return state;
    },

    removeStartNode(state) {
        state.startNode = null;
        return state;
    },
    removeEndNode(state) {
        state.endNode = null;
        return state;
    },

    setCoordinates(state, action) {
        state.coordinates = action.payload;
        return state;
    },
    addCoordinate(state, action) {
        state.coordinates.push(action.payload);
        return state;
    },

    reset(state) {
        state.startNode = null;
        state.endNode = null;
        state.coordinates = [];
        return state;
    },

    toggleDraw(state) {
        state.drawOnMap = !state.drawOnMap;
        return state;
    },
};

const coordinatesReducer = createSlice({
    name: "coordinates",
    initialState,
    reducers,
});

export const {
    addStartNode,
    addEndNode,
    removeStartNode,
    removeEndNode,
    setCoordinates,
    addCoordinate,
    reset,
    toggleDraw,
} = coordinatesReducer.actions;
export default coordinatesReducer.reducer;
