<?php

namespace App\Http\Controllers;

use App\Classes\MikrotikService\SyncWithMk;
use App\Http\Controllers\Clients\IdEnableDisableController;
use App\Http\Controllers\Customer\CustomerFrontController;
use App\Models\Client;
use App\Models\User_log;
use App\Services\GenerateMonthlyBill;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReactiveCustomerController extends Controller
{
    public function reactiveFromCustomer(Request $request)
    {
        $customer_info = CustomerFrontController::getinfo($request);

        $re_active_btn_condition = $customer_info->clients_status == "deactive" && Carbon::parse($customer_info->expire_date)->addMonth(1)->format('Y-m-d') < today()->format('Y-m-d') && globalPermission('customerPortalReactive');

        if(!$re_active_btn_condition){
            Toastr::info("Client re-active is not open");
            return redirect()->back();
        }
        // dd($details);
    //    $dd =  (new IdEnableDisableController())->idEnable($details['userinfo']->id,'Client reactive from customer');
        $id = $customer_info->id;
        $details = "Client reactive from customer";
        $client = Client::with('pop', 'pop.nas', 'packages', 'customerAccount')->find($id);




        DB::beginTransaction();

        try {

            if (Carbon::parse($client->expire_date)->addDay($client->payment_dadeline) < today()) {

                $dif = Carbon::parse($client->expire_date)->diffInMonths(today());

                if ($dif > 0 && $client->pop->bill_generate == 'yes') {



                    $new_exp = Carbon::parse(date($client->billing_cycle . '-m-Y'));
                    $newExpireDayWithCurrentDay = date('Y-m-d 00:00:00');

                    if ($client->billing_cycle > date('d')) {

                        if (getBillingType() != 'day_to_day') {
                            (new GenerateMonthlyBill)->generate($client);
                        }

                       $client->expire_date = Carbon::parse($newExpireDayWithCurrentDay)->subDay(1);
                       $client->billing_cycle = date('d');
                       $client->clients_status = $client->pop->experity_check == 'Yes' ? 'expired' : 'disable';
                       $client->save();
                       (new GenerateMonthlyBill)->generate($client);
                       (new idenabledisablecontroller())->enableInRadius($client);
                   } else {

                       $new_exp = Carbon::parse($new_exp)->addMonth();
                       $newExpireDayWithCurrentDay = date('Y-m-d 00:00:00');


                       $client->expire_date = Carbon::parse($newExpireDayWithCurrentDay)->subDay(1);
                       $client->billing_cycle = date('d') - 1;
                       $client->clients_status =  $client->pop->experity_check == 'Yes' ? 'expired' : 'disable';
                       $client->save();

                       (new GenerateMonthlyBill)->generate($client);
                   }
               } else {
                   (new idenabledisablecontroller())->enableInRadius($client, false);
                //    dd("comes");

                   (new idenabledisablecontroller())->generatePreviousMonthBill($client);
                   (new GenerateMonthlyBill)->generate($client);


                   $client->clients_status = 'expired';
                   $client->save();
               }
           } else {
               $client->clients_status = 'active';
               $client->save();
               (new idenabledisablecontroller())->enableInRadius($client);
           }

           if ($client->pop->experity_check == 'Yes') {
               (new idenabledisablecontroller())->enableInRadius($client);
            }


            // $auth_user_id = isset(auth()->id()) ? auth()->id() : 1;
            $auth_user_id = isset(auth()->user()->id) ? auth()->user()->id : 1;

            User_log::create([
                'log_type' => 'id_enable',
                'user_id' => $auth_user_id,
                'details' => $details,
                'client_id' => $client->id
            ]);


           $mikrotik = new SyncWithMk();
           $mikrotik->syncSingleClient($client->id);
           DB::commit();
           Toastr::success("Re Active is successfull");
            return redirect()->route('customer-payment');

       } catch (\Throwable $th) {

           DB::rollback();

           Toastr::error($th, 'error');
           return redirect()->back();
       }
    }
}
