<!DOCTYPE html>

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>Dashboard</title>
    <meta content="" name="description">
    <meta content="" name="keywords">

    <!-- Favicons -->
    {{-- <link href="{{ asset('niceAdmin/assets/img/favicon.png') }}" rel="icon"> --}}
    {{-- <link href="{{ asset('niceAdmin/assets/img/apple-touch-icon.png') }}" rel="apple-touch-icon"> --}}

    <link rel="icon" type="image/png" href="{{ asset('storage/company/' . siteinfo()->img_url ?? '') }}">
    {{-- <link rel="icon" type="image/jpeg" href="{{ asset('storage/company/' . siteinfo()->img_url ?? '') }}"> --}}

    <!-- Google Fonts -->
    <link href="https://fonts.gstatic.com" rel="preconnect">
    <link
        href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i"
        rel="stylesheet">

    <!-- Vendor CSS Files -->
    <link href="{{ asset('niceAdmin/assets/vendor/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset('niceAdmin/assets/vendor/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet">
    <link href="{{ asset('niceAdmin/assets/vendor/boxicons/css/boxicons.min.css') }}" rel="stylesheet">
    <link href="{{ asset('niceAdmin/assets/vendor/quill/quill.snow.css') }}" rel="stylesheet">
    <link href="{{ asset('niceAdmin/assets/vendor/quill/quill.bubble.css') }}" rel="stylesheet">
    <link href="{{ asset('niceAdmin/assets/vendor/remixicon/remixicon.css') }}" rel="stylesheet">
    <link href="{{ asset('niceAdmin/assets/vendor/simple-datatables/style.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('/') }}css/clientbootcss.min.css">

    <link href="{{ asset('niceAdmin/assets/css/style.css') }}" rel="stylesheet">
    <style>
        .btn {
            display: inline-block;
            font-weight: 600;
            text-align: center;
            vertical-align: middle;
            user-select: none;
            border: 1px solid transparent;
            padding: 0.5rem 1rem;
            font-size: 1rem;
            line-height: 1.5;
            border-radius: 0.375rem;
            transition: all 0.2s ease-in-out;
        }

        .btn-primary {
            background-color: #007bff;
            color: white;
            border-color: #007bff;
        }

        .btn-primary:hover {
            background-color: #0056b3;
            border-color: #004085;
        }

        .btn-lg {
            padding: 0.75rem 1.5rem;
            font-size: 1.25rem;
            border-radius: 0.5rem;
        }

        .btn-block {
            display: block;
            width: 100%;
        }

        /* .center-content {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        } */
    </style>

    <style>
        .news-marquee {
            width: 100%;
            overflow: hidden;
            background-color: #fffbea;
            border-top: 2px solid #ff9900;
            border-bottom: 2px solid #ff9900;
            padding: 10px 0;
            position: relative;
        }

        .news-track {
            display: flex;
            width: fit-content;
            animation: scroll-left 60s linear infinite;
            /* speed + delay */
            /* animation: scroll-left 60s linear 1s infinite; */
        }

        .news-text {
            white-space: nowrap;
            font-size: 18px;
            font-weight: bold;
            color: #d60000;
            padding-left: 50vw;
            /* Push start off-screen */
        }

        /* Animation */
        @keyframes scroll-left {
            0% {
                transform: translateX(0);
            }

            100% {
                transform: translateX(-100%);
            }
        }

        /* Pause on hover */
        .news-marquee:hover .news-track {
            animation-play-state: paused;
        }

        /* Responsive */
        @media (max-width: 600px) {
            .news-text {
                font-size: 14px;
            }
        }
    </style>
</head>

<body
    style="background-image: url('{{ asset('images/payment_bg.jpg') }}'); background-size: cover; background-position: center;">
    <header id="header" class="header fixed-top d-flex align-items-center"
        style="background-color: transparent !important; box-shadow: none !important;">
        <div class="d-flex align-items-center justify-content-between">
            <a href="#" class="logo d-flex align-items-center">
                <span class="d-none d-lg-block" style="color: #ffffff;">{{ siteinfo()->name }}</span>
            </a>
        </div>

        <nav class="header-nav ms-auto">
            <ul class="d-flex align-items-center">
                <li class="nav-item dropdown pe-3">
                    <a class="nav-link nav-profile d-flex align-items-center pe-0" href="#"
                        data-bs-toggle="dropdown">
                        <img src="{{ asset('niceAdmin/assets/img/profile-img.jpg') }}" alt="Profile"
                            class="rounded-circle">
                        <span class="d-none d-md-block ps-2"
                            style="color: #ffffff;">{{ $details['userinfo']->clientsinfo->clients_name }}</span>
                    </a>
                </li>
            </ul>
        </nav>
    </header>

    <main id="main" class="main pt-4">
        <section class="section profile">
            <div class="row">
                <div class="col-xl-9">
                    <div class="card pt-4">


                        <div class="news-marquee">
                            <div class="news-track">
                                <div class="news-text">
                                    {!! siteinfo()->notification !!} &nbsp; • &nbsp;
                                    {!! siteinfo()->notification !!} &nbsp; • &nbsp;
                                    {!! siteinfo()->notification !!} &nbsp; • &nbsp;
                                    {!! siteinfo()->notification !!} &nbsp; • &nbsp;
                                </div>
                            </div>
                        </div>


                        <div class="card-body pt-3">
                            @if (Session::has('successMsg'))
                                <p class="alert alert-info">{{ Session::get('successMsg') }}</p>
                            @endif
                            @if (Session::has('error'))
                                <p class="alert alert-danger">{{ Session::get('error') }}</p>
                            @endif

                            <div class="tab-content pt-2">
                                <div class="tab-pane fade show active profile-overview" id="profile-overview">
                                    <h5 class="card-title">Profile Details</h5>

                                    @if (json_decode(siteinfo()->payment_url)->payment_url_enable == 'on')
                                        <h2>Pay now Using Different Url</h2>
                                        <a href="{{ json_decode(siteinfo()->payment_url)->payment_url }}"
                                            target="_blank" class="btn btn-danger mb-5" style="padding:10px 50px;">Pay
                                            Now</a>
                                    @endif

                                    <div class="row">
                                        <div class="col-lg-3 col-md-3 label">Subscriber ID</div>
                                        <div class="col-lg-3 col-md-3">{{ $details['userinfo']->id }}</div>
                                        <div class="col-lg-3 col-md-3 label ">Full Name</div>
                                        <div class="col-lg-3 col-md-3">
                                            {{ $details['userinfo']->clientsinfo->clients_name }}
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-3 label">STATUS</div>
                                        <div class="col-lg-3 col-md-3">
                                            @if ($details['userinfo']->clients_status == 'expired')
                                                <span
                                                    class="badge bg-danger">{{ $details['userinfo']->clients_status }}</span>
                                            @else
                                                <span
                                                    class="badge bg-success">{{ $details['userinfo']->clients_status }}</span>
                                            @endif
                                        </div>
                                        <div class="col-lg-3 col-md-3 label">PACKAGE NAME</div>
                                        <div class="col-lg-3 col-md-3">{{ $details['package']->package_name }}</div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-3 label">PACKAGE PRICE</div>
                                        <div class="col-lg-3 col-md-3">{{ $details['package']->package_rate }}</div>
                                        <div class="col-lg-3 col-md-3 label">CURRENT BALANCE</div>
                                        <div class="col-lg-3 col-md-3">
                                            @if (isset($details['account']->dueAmount) && $details['account']->dueAmount < 1)
                                                {{ abs($details['account']->dueAmount) }}
                                            @else
                                                0
                                            @endif
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-3 label">Due Balance</div>
                                        <div class="col-lg-3 col-md-3">
                                            @if (isset($details['account']->dueAmount) && $details['account']->dueAmount > 0)
                                                <span class="text-red-600 font-bold">
                                                    {{ abs($details['account']->dueAmount) }} BDT</span>
                                            @else
                                                0 BDT
                                            @endif
                                        </div>
                                        <div class="col-lg-3 col-md-3 label">EXPIRE DATE</div>
                                        <div class="col-lg-3 col-md-3">
                                            {{ date('d-M-Y', strtotime($details['userinfo']->expire_date)) }}</div>
                                    </div>

                                    <div class="row d-none">
                                        <div class="col-lg-3 col-md-4 label ">Name</div>
                                        <div class="col-lg-9 col-md-8">
                                            <input type="text" name="customer_name" class="border px-3 py-1"
                                                id="customer_name" placeholder=""
                                                value="{{ $details['userinfo']->clientsinfo->clients_name }}"
                                                value="" required>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">Mobile</div>
                                        <div class="col-lg-9 col-md-8">
                                            <input type="text" name="customer_mobile" class="border px-4 py-1"
                                                id="mobile" placeholder="Mobile" readonly
                                                value="{{ $details['userinfo']->clientsinfo->contact_no }}" required>
                                        </div>
                                    </div>

                                    <div class="row d-none">
                                        <div class="col-lg-3 col-md-4 label">Email</div>
                                        <div class="col-lg-9 col-md-8">
                                            <input type="email" name="customer_email" class="border px-4 py-1"
                                                id="email"
                                                value="{{ $details['userinfo']->clientsinfo->email ?? 'test@gmail.com' }}"
                                                placeholder="you@example.com" required>
                                        </div>
                                    </div>

                                    <div class="row d-none">
                                        <div class="col-lg-3 col-md-4 label">Address</div>
                                        <div class="col-lg-9 col-md-8">
                                            <input type="text" class="border px-4 py-1 " id="address"
                                                name="address1" placeholder="1234 Main St"
                                                value="{{ $details['userinfo']->clientsinfo->area }}" value=""
                                                required>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">Payment Amount</div>
                                        <div class="col-lg-9 col-md-8">
                                            <input type="hidden" id="customer_id" name="customer_id" class=""
                                                value="{{ $details['userinfo']->id }}">

                                            @if (getBillingType() === 'day_to_day')
                                                <input type="hidden" min="0" value="{{ $bill_amount }}"
                                                    name="amount" id="amount" class="border px-4 py-1"
                                                    required {{ (checkSettings('change_payment_amount_client_portal') == 'enable' ? '' : 'readonly') }}/>
                                                {{ $bill_amount }}
                                            @else
                                                @if (isset($details['account']->dueAmount) && $details['account']->dueAmount > 0)
                                                    <input type="number" min="0" name="amount"
                                                        id="amount"
                                                        value="{{ abs($details['account']->dueAmount) }}"
                                                        class="border px-4 py-1" required {{ (checkSettings('change_payment_amount_client_portal') == 'enable' ? '' : 'readonly') }}/>
                                                @else
                                                    <input type="number" min="0" name="amount"
                                                        id="amount"
                                                        value="{{ $details['package']->package_rate - $details['userinfo']->parmanent_discount ?? 0 }}"
                                                        class="border px-4 py-1" required {{ (checkSettings('change_payment_amount_client_portal') == 'enable' ? '' : 'readonly') }}/>
                                                @endif
                                            @endif
                                        </div>
                                    </div>

                                    @php
                                        $payment_button = collect(siteinfo()->payment_button);
                                        $bkash_image_btn = $buttons->where('type', 'bkash_img')->first();
                                        $ssl_image_btn = $buttons->where('type', 'ssl_img')->first();
                                        $upay_image_btn = $buttons->where('type', 'upay_img')->first();
                                        $nagad_image_btn = $buttons->where('type', 'nagod_img')->first();

                                    @endphp

                                    <div class="row">
                                        <div class="col-lg-3 col-md-3 label">{{-- Pay Now --}}</div>
                                        <div class="col-lg-9 col-md-8">
                                            @if (checkSettings('ssl-commerz-show') == 'enable')
                                                <td class="p-2 w-1/2">
                                                    <button type="button" id="paySSL" class="btn btn-default">
                                                        pay with SSLCommerz

                                                        <img style="height:50px;border:1px solid #ddd; border-radius:5px;padding:5px;"
                                                            src="@if (!empty($ssl_image_btn)) {{ asset('storage/company/' . $ssl_image_btn->value) }} @else visa.png @endif"
                                                            alt="">
                                                    </button>

                                                    <button style="display: none"
                                                        class="btn btn-primary btn-lg btn-block" id="sslczPayBtn"
                                                        token="if you have any token validation"
                                                        postdata="your javascript arrays or objects which requires in backend"
                                                        order="If you already have the transaction generated for current order"
                                                        endpoint="{{ url('/pay-via-ajax') }}"> Pay Now
                                                    </button>
                                                </td>
                                            @endif

                                            @if (checkSettings('bkash-show') == 'enable')
                                                <td class="p-2 w-1/2">

                                                    @if (checkSettings('bkash-tokenized') == 'enable')
                                                        <button class="btn btn-default" id="bKash_payment">Pay with
                                                            bKash

                                                            <img style="height:50px;border:1px solid #ddd; border-radius:5px;padding:5px;"
                                                                src="@if (!empty($bkash_image_btn)) {{ asset('storage/company/' . $bkash_image_btn->value) }} @else https://www.bkash.com/sites/all/themes/bkash/logo.png @endif"
                                                                alt="">
                                                        </button>
                                                    @endif

                                                    @if (checkSettings('bkash-checkout') == 'enable')
                                                        <button id="bKash_button" class="btn btn-default"
                                                            onclick="BkashPayment()">
                                                            <img style="height:50px;border:1px solid #ddd; border-radius:5px;padding:5px;"
                                                                src="@if (!empty($bkash_image_btn)) {{ asset('storage/company/' . $bkash_image_btn->value) }} @else https://www.bkash.com/sites/all/themes/bkash/logo.png @endif"
                                                                alt="">
                                                        </button>
                                                    @endif

                                                </td>
                                            @endif

                                            @if (checkSettings('uddokta-pay-show') == 'enable')
                                                <td class="p-2 w-1/2">
                                                    <button class="btn btn-danger" type="button"
                                                        id="uddokta_pay">Uddokta Pay</button>
                                                </td>
                                            @endif

                                            @if (checkSettings('pay-with-eps') == 'enable')
                                                <td class="p-2 w-1/2">
                                                    <button class="btn btn-danger" type="button" id="eps_pay">EPS
                                                        Pay</button>
                                                </td>
                                            @endif

                                            @if (checkSettings('upay-payment') == 'enable')
                                                <button class="btn btn-default" id="upay_payment">
                                                    Pay with Upay
                                                    <img style="height:50px;border:1px solid #ddd; border-radius:5px;padding:5px;"
                                                        src="@if (!empty($upay_image_btn)) {{ asset('storage/company/' . $upay_image_btn->value) }} @else @endif"
                                                        alt="">
                                                </button>
                                            @endif

                                            @if (checkSettings('nagad-checkout-client-payment') == 'enable')
                                                <button class="btn btn-default" id="nagad_payment">
                                                    Pay with Nagad
                                                    <img style="height:50px;border:1px solid #ddd; border-radius:5px;padding:5px;"
                                                        src="@if (!empty($nagad_image_btn)) {{ asset('storage/company/' . $nagad_image_btn->value) }} @else @endif"
                                                        alt="">
                                                </button>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label"></div>
                                        <div class="col-lg-9 col-md-8">
                                        </div>
                                    </div>
                                </div><!-- End Bordered Tabs -->
                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </main>

    @section('script')
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"
            integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"
            integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous">
        </script>
        <link rel="stylesheet" href="{{ asset('/') }}css/toastr.min.css">
        <script src="{{ asset('/') }}js/toastr.min.js"></script>

        {!! Toastr::message() !!}

        @if (checkSettings('ssl-commerz-show') == 'enable')
            @include('Customer.sslcommerz-script')
        @endif

        @if (checkSettings('bkash-tokenized') == 'enable')
            @include('Customer.bkash-tokenized')
        @endif
        @if (checkSettings('bkash-checkout') == 'enable')
            @include('Customer.bkash-checkout')
        @endif
        @if (checkSettings('upay-payment') == 'enable')
            @include('Customer.upay-payment')
        @endif

        @if (checkSettings('nagad-checkout-client-payment') == 'enable')
            @include('Customer.nagad_checkout')
        @endif

        <script>
            // onclick uddokta_pay button send request to pay route
            $('#uddokta_pay').click(function() {

                if ($('#amount').val() == '') {
                    toastr.error('Amount is required');
                } else if ($('#customer_name').val() == '') {
                    toastr.error('Customer name is required');
                } else if ($('#mobile').val() == '') {
                    toastr.error('Mobile number is required');
                } else {
                    //submit for
                    $.ajax({
                        url: "{{ route('uddoktapay.pay') }}",
                        type: "POST",
                        data: {
                            full_name: $('#customer_name').val(),
                            mobile: $('#mobile').val(),
                            email: $('#email').val(),
                            amount: $('#amount').val(),
                            customer_id: $('#customer_id').val()
                        },
                        success: function(data) {
                            if (data.status == 'success') {
                                window.location.href = data.payment_url;
                            } else {
                                toastr.error(data.message);
                            }
                            //
                        }
                    });
                }
            });


            var obj = {};

            $('#eps_pay').on('click', function() {
                obj.cus_name = $('#customer_name').val();
                obj.cus_phone = $('#mobile').val();
                obj.cus_email = $('#email').val() == '' ? 'demo@example.com' : $('#email').val();
                obj.cus_addr1 = $('#address').val();
                obj.amount = $('#amount').val();
                obj.customer_id = $('#customer_id').val();

                console.log('comes to eps here');

                if ($('#mobile').val() != '' && $('#amount').val() != '' && $('#amount').val() != '') {
                    var token = '{{ csrf_token() }}';

                    $.ajax({
                        url: "{{ route('eps-payment-token') }}",
                        type: 'GET',
                        data: obj,
                        headers: {
                            "X-CSRF-TOKEN": token
                        },
                        success: function(result) {
                            if (result.status == 'error') {
                                toastr.error(result.message);
                            } else {
                                window.location.href = result.RedirectURL;
                                // $(location).attr('href', result.message);
                            }
                            console.log(result, 'response Result');
                        },
                        error: function(err) {
                            toastr.error(err.message);
                        }
                    });
                } else {
                    if ($('#mobile').val() == '') {
                        toastr.error('Mobile Number is required');
                    }
                    if ($('#amount').val() == '') {
                        toastr.error('Amount is required');
                    }
                }
            });
        </script>
    @endsection


    <!-- ======= Footer ======= -->
    <footer id="" class="footer" style="position: fixed; bottom: 0; width: 100%;">
        <div class="copyright" style="color: #ffffff;">
            &copy; 2020-{{ date('Y') }} <strong><span><a href="https://yetfix.com/"
                        style="color: #6ffff8;">YetFix
                        Limited</a></span></strong>. All Rights Reserved
        </div>
    </footer><!-- End Footer -->

    <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i
            class="bi bi-arrow-up-short"></i></a>

    <!-- Vendor JS Files -->
    <script src="{{ asset('niceAdmin/assets/vendor/apexcharts/apexcharts.min.js') }}"></script>
    <script src="{{ asset('niceAdmin/assets/vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('niceAdmin/assets/vendor/chart.js/chart.min.js') }}"></script>
    <script src="{{ asset('niceAdmin/assets/vendor/echarts/echarts.min.js') }}"></script>
    <script src="{{ asset('niceAdmin/assets/vendor/quill/quill.min.js') }}"></script>
    <script src="{{ asset('niceAdmin/assets/vendor/simple-datatables/simple-datatables.js') }}"></script>
    <script src="{{ asset('niceAdmin/assets/vendor/tinymce/tinymce.min.js') }}"></script>
    <script src="{{ asset('niceAdmin/assets/vendor/php-email-form/validate.js') }}"></script>

    <!-- Template Main JS File -->
    <script src="{{ asset('niceAdmin/assets/js/main.js') }}"></script>
    @yield('script')
    <script src="{{ asset('/') }}js/clientjquery.min.js"></script>
    <script src="{{ asset('/') }}js/clienttoastr.min.js"></script>

    {!! Toastr::message() !!}

</body>

</html>
