<div class="mb-2">
    <button class="btn btn-primary" onclick="export2csv()">Download csv</button>
</div>
<div class="col-md-12">
    <div class="badge badge-info float-right m-1" style="text-align: ">Total Row: {{ $list->count() }}</div>
    <div class="badge badge-info float-right m-1" style="text-align: ">Total Amount {{ $list->sum('amount') }} TK</div>
    @can('show_commission_reseller_balance_log')
        <div class="badge badge-info float-right m-1" style="text-align: ">Total  Manager Miscellaneous Expense {{ $list->sum('commission') }} TK</div>
    @endcan

</div>
<div class="table-responsive">
    <table class="table table-bordered table-striped table-condensed" id="tableId">
        <thead class="bg-blue-50">
            <tr>
                <th scope="col" class="">
                    ID
                </th>
                <th scope="col" class="">
                    Date
                </th>

                <th scope="col" class="">
                    Reseller Name
                </th>
                @can('reseller_balance_log_with_pop')

                    <th scope="col" class="">
                        Pop Name
                    </th>
                @endcan

                <th scope="col" class="">
                    User Name
                </th>
                <th scope="col" class="">
                    Action
                </th>

                <th scope="col" class="">
                    Amount
                </th>
                @can('show_commission_reseller_balance_log')
                    <th scope="col" class="">
                        Manager Miscellaneous Expense
                    </th>
                @endcan
                @can('show_commission_percentage_reseller_balance_log')
                    <th scope="col" class="">
                        Manager Miscellaneous Expense
                    </th>
                @endcan
                @if (checkSettings('ResellerClientOnlineRecharge') == 'enable')
                    <th scope="col" class="">
                        Client Bill
                    </th>

                @endif

                <th scope="col" class="">
                    Remarks
                </th>
            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-200">

            @php $total = 0; $manger_commission = 0;  @endphp

            @foreach ($list as $r)

                <tr>
                    <td class="px-6 py-2 whitespace-nowrap">
                        {{ $r->id }}
                    </td>
                    <td class="px-6 py-2 whitespace-nowrap">
                        {{ date('d-M-Y h:i:sa', strtotime($r->created_at)) }}
                    </td>

                    <td class="px-6 py-2 whitespace-nowrap text-sm text-gray-500">
                        {{ $r->reseller->name ?? '' }}
                    </td>
                    @can('reseller_balance_log_with_pop')
                        <td class="px-6 py-2 whitespace-nowrap text-sm text-gray-500">
                            {{ $r->pop->popname ?? '' }}
                        </td>
                    @endcan

                    <td class="px-6 py-2 whitespace-nowrap text-sm text-gray-500">
                        {{ $r->client->userid ?? '' }}
                    </td>

                    <td class="px-6 py-2 whitespace-nowrap text-sm text-gray-500">
                        {{ $r->action ?? '' }}
                    </td>

                    <td class="px-6 py-2 whitespace-nowrap text-right">
                        @php $total += $r->amount @endphp
                        {{ $r->amount }}
                    </td>
                    @can('show_commission_reseller_balance_log')
                        <td class="px-6 py-2 whitespace-nowrap text-right">
                            {{ $r->commission ?? 0 }}
                        </td>
                    @endcan

                    @can('show_commission_percentage_reseller_balance_log')
                        @php
                            if($r->amount != 0 && $r->reseller_commission_percentage != 0){
                               $this_row_commission = ($r->amount * $r->reseller_commission_percentage) / 100;
                            }else{
                                $this_row_commission = 0;
                            }
                            $manger_commission += $this_row_commission;
                        @endphp
                        <td class="px-6 py-2 whitespace-nowrap text-right">
                            {{ $this_row_commission ?? 0 }}
                        </td>
                    @endcan

                    @if (checkSettings('ResellerClientOnlineRecharge') == 'enable')
                        <td class="px-6 py-2 whitespace-nowrap text-sm text-gray-500">
                            @if (checkSettings('setClientPaymentAmountToClient') == 'enable' && $r->client->client_payment_amount > 0)
                                {{ $r->client->client_payment_amount ?? '' }}
                            @else
                                {{ $r->client->packages->client_payment_amount ?? '' }}
                            @endif
                        </td>
                    @endif

                    <td class="px-6 py-2 whitespace-nowrap text-sm text-gray-500 text-right">
                        {{ $r->remarks }}
                    </td>

                </tr>

            @endforeach

            <tr>
                <td></td><td></td><td></td>
                <td colspan="2" class="text-right">Total: </td>
                <td class="px-6 py-2 whitespace-nowrap text-right">{{ number_format($total, 2, '.', '') }}</td>
                @can('show_commission_reseller_balance_log')
                    <td class="px-6 py-2 whitespace-nowrap text-right">{{ number_format($list->sum('commission'), 2, '.', '') }}</td>
                @endcan
                @can('show_commission_percentage_reseller_balance_log')

                    <td class="px-6 py-2 whitespace-nowrap text-right">
                        {{ $manger_commission ?? 0 }}
                    </td>
                @endcan
                @if (checkSettings('ResellerClientOnlineRecharge') == 'enable')
                    <td></td>
                @endif
                <td></td>
            </tr>

            <!-- More items... -->
        </tbody>
    </table>
</div>

<div class="p-5">
    {{-- {{ $list->links() }} --}}
</div>
