@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="col-md-3">
                <a href="{{ route('tokenCat.create') }}">
                    <button class="btn btn-success ">
                        <i class="fa fa-plus"></i> Category
                    </button>
                </a>
            </div>
            <br>
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="dataTable" class="table table-bordered table-striped table-condensed">
                        <thead class="bg-gray-50">
                            <tr class="bg-black text-center">
                                <th>
                                    ID
                                </th>
                                <th>
                                    Token Category
                                </th>
                                <th>
                                    Action
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($categoty as $r)
                                <tr>
                                    <td>
                                        {{ $r->id }}
                                    </td>
                                    <td>
                                        {{ $r->tokenCategory }}
                                    </td>
                                    <td>
                                        <div class="row float-right">
                                            <a href="{{ route('tokenCat.edit', $r->id) }}">
                                                <button class=" btn btn-primary ">
                                                    Edit</button>
                                            </a>
                                            <form action="{{ route('tokenCat.destroy', $r->id) }}" method="POST">
                                                @method('DELETE')
                                                @csrf

                                                <button class="ml-2 btn btn-danger ">Delete</button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            <!-- More items... -->
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="p-5">
                {{-- {{ $employees->links() }} --}}
            </div>
        </div>
    </div>
    </div>
    </div>
    </div>




@endsection


@section('ajax')
    <script type="text/javascript">
        $(document).ready(function() {
            $('#dataTable').DataTable();
        });
    </script>
@endsection
