@extends('layout.app')


@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title" style="color:#115548;">Customet List</h3>
            <div class="card-tools">
                <a href="{{ route('bw-customer.create') }}"><button class="btn btn-sm btn-primary"><i
                            class="fa fa-plus-circle" aria-hidden="true"></i> &nbsp; Customer</button></a>
            </div>
        </div>

        <div class="card-body">

            <div class="table-responsive">
                <table id="dataTable" class="display">
                    <thead class="bg-gray-50">
                        <tr>
                            <th> ID </th>
                            <th> Company Name </th>
                            <th> Mobile </th>
                            <th> Email </th>
                            <th> Contact Person </th>
                            <th> Reference By </th>
                            <th> Address </th>
                            <th> Remarks </th>
                            <th> Status </th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach ($list as $row)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $row->customer_name }}</td>
                                <td>{{ $row->phone }}</td>
                                <td>{{ $row->email  }}</td>
                                <td>{{ $row->contact_person }}</td>
                                <td>{{ $row->reference_by }}</td>
                                <td>{{ $row->address }}</td>
                                <td>{{ $row->remarks }}</td>
                                <td>{{ $row->status }}</td>
                                <td style="">
                                    <div class="row">
                                        <div>
                                            <a href="{{ route('bw-customer.edit', $row->id) }}"
                                                class="btn btn-warning">Edit</a>
                                        </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
