import { toast } from 'react-hot-toast';
import axiosInstance from '../../util/axiosInstance';
import { setTjBoxes, addTjBox, removeTjBox } from '../reducers/tjBoxReducer';

export const fetchTjBoxData = () => async (dispatch) => {
    try {
        const { data } = await axiosInstance.get('/tj-boxes');
        dispatch(setTjBoxes(data));
    } catch (error) {
        toast.error(error.response.data.message);
    }
};

export const addNewTjBox = (tjBoxData, callback) => async (dispatch) => {
    try {
        const { data } = await axiosInstance.post('/tj-boxes', tjBoxData);
        dispatch(addTjBox(data));
        callback(data);
        toast.success('TJ Box Added Successfully');
    } catch (error) {
        toast.error(error.response.data.message);
    }
};

export const deleteTjBox = (tjBoxId, callback) => async (dispatch) => {
    try {
        await axiosInstance.delete(`/tj-boxes/${tjBoxId}`);
        callback();
        dispatch(removeTjBox(tjBoxId));
        toast.success('TJ Box Deleted Successfully');
    } catch (error) {
        toast.error(error.response.data.message);
    }
};
