@extends('layout.app')

@section('content')

    <div class="flex flex-col mt-2">
        <div class=" bg-white p-6 rounded-lg">
            <form action="{{route('status.change')}}" method="post">
                @csrf
                <div class="border-2 mb-2">

                    <div class="bg-blue-100 block p-2">

                        <div class="grid grid-cols-3 p-2">
                            <div class="px-2 flex justify-between items-center">
                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="pop_id">
                                  Pop Name
                                </label>


                                <select name="pop_id"
                                        class="flex-1 relative w-full bg-white border border-gray-300 rounded-md shadow-sm pl-3 pr-10 py-2 text-left cursor-default focus:outline-none focus:ring-1 focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm" required>
                                    <option value="">Select Pop</option>
                                    @foreach ($non_expired_pops as $nas)
                                        <option class="p-5" value="{{ $nas->id }}">{{ $nas->popname }} </option>
                                    @endforeach

                                </select>
                            </div>
                            <div>
                                <div class="flex justify-end">
                                    <button @click="search"
                                            class="inline-block px-6 py-2 text-white bg-blue-600 float-right mr-2 mb-2"
                                            type="submit" id="searchBtn">Disable</button>
                                    <button class="inline-block px-4 py-2 text-white bg-yellow-600 float-right mr-2 mb-2"
                                            type="reset" id="reset">Reset</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>

            <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
                <div class="py-2 align-middle inline-block min-w-full sm:px-6 lg:px-8">
                    <div class="shadow overflow-hidden border-b border-gray-200 sm:rounded-lg">
                        <table id="dataTable" class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                            <tr>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    ID
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Pop name
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Reseller Name
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    NAS Server IP
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    POP Location
                                </th>
                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    POP Status
                                </th>

                                <th scope="col"
                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">

                                </th>
                            </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach($expired_pops as $r)
                                <tr>
                                    <td>
                                        {{ $r->id }}
                                    </td>
                                    <td>
                                        {{ $r->popname ?? ''}}
                                    </td>
                                    <td>
                                        {{$r->reseller->name}}
                                    </td>

                                    <td class="whitespace-nowrap">
                                        {{$r->nas->nasname}}
                                    </td>
                                    <td>
                                        {{$r->pop_location}}
                                    </td>
                                    <td>
                                        {{$r->status}}
                                    </td>
                                    <td class="px-6 text-left text-sm font-medium">
                                        <form action="{{route('status.change')}}" method="POST">
                                            @csrf
                                            <input type="hidden" name="pop_id" value="{{ $r->id }}">
                                            <button type="submit" class="bg-red-500 text-white p-2"><i class="fa fa-trash"></i> Delete</button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>

                        {{-- <div class="p-5">
                                    {{ $list->links() }}
                    </div> --}}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


