@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <button type="button" class="btn btn-info btn-small mb-2" data-toggle="modal" data-target="#assignTokenModel">Add
                token</button>
            <form action="" id="search">
                <div class="row">

                    <div class="col-md-3 col-sm-3 col-lg-3">
                        <label class="" for="from_date">
                            From Date
                        </label>
                        <div class="form-group">
                            <input type="date" name="from_date" value="{{ $start->format('Y-m-d') }}"
                                class="form-control">
                        </div>
                    </div>

                    <div class="col-md-3 col-sm-3 col-lg-3">
                        <label class="" for="to_date">
                            To Date
                        </label>
                        <div class="form-group">
                            <input type="date" name="to_date" value="{{ $end->format('Y-m-d') }}" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-3 col-lg-3">
                        <label for="name">
                            Manager Name
                        </label>
                        <select class="form-control bSelect select2" name="name" id="reseller"
                            style="text-align:center">
                            <option value="">All Manager</option>
                            @foreach ($reseller as $item)
                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3 col-sm-3 col-lg-3">
                        <label> Select POP </label>
                        <select name="pop" id="pop" class="form-control form-control-sm select2">
                            <option value="all"> Select One</option>
                        </select>
                    </div>
                    <div class="col-md-3 col-sm-3 col-lg-3">
                        <label for="token_type">
                            Token Type
                        </label>
                        <select class="form-control bSelect select2" name="token_type" style="text-align:center">
                            <option value="">Any Type</option>
                            <option value="Logical">Logical</option>
                            <option value="Physical">Physical</option>
                        </select>
                    </div>
                    <div class="col-md-3 col-sm-3 col-lg-3">
                        <label for="tokenCode">
                            Token Code
                        </label>
                        <select class=" form-control bSelect select2" name="tokenCode" style="text-align:center">
                            <option value="">Any Code</option>
                            @foreach ($tokenCode as $item)
                                <option value="{{ $item->id }}">{{ $item->tokenCode }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3 col-sm-3 col-lg-3">
                        <label for="createdBy">
                            Created By
                        </label>
                        <select class="form-control bSelect select2" name="createdBy" style="text-align:center">
                            <option value="">Any User</option>
                            @foreach ($created as $item)
                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3 col-sm-3 col-lg-3">
                        <label for="closeUserId">
                            Closed By
                        </label>
                        <select class="form-control bSelect select2" name="closeUserId" style="text-align:center">
                            <option value="">Any User</option>
                            @foreach ($closed as $item)
                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3 col-sm-3 col-lg-3">
                        <label for="status">
                            Status
                        </label>
                        <select class="form-control bSelect" name="status" style="text-align:center">
                            <option value="">Any</option>
                            <option value="Active">Open</option>
                            <option value="Inactive">Closed</option>
                        </select>
                    </div>
                    <div class="col-md-3 col-sm-3 col-lg-3">
                        <label for="clientId">
                            Customer Id
                        </label>
                        <input style="text-align:center" class="form-control " name="clientId" type="text" placeholder=""
                            onclick="">
                    </div>
                    <div class="col-md-3 col-sm-3 col-lg-3">
                        <label for="token">
                            Token Id
                        </label>
                        <input style="text-align:center" class="form-control" name="token" type="text" placeholder=""
                            onclick="">
                    </div>
                    <div class="col-md-3 col-sm-3 col-lg-3">
                        <label for="assignToken">
                            Solved By
                        </label>
                        <select class="form-control bSelect select2" name="assignToken" style="text-align:center">
                            <option value="">All Employee</option>
                            @foreach ($employee as $item)
                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3 col-sm-3 col-lg-3">
                        <label for="userName">
                            User Name
                        </label>
                        <input style="text-align:center" class="form-control" name="userName" type="text" placeholder=""
                            onclick="">
                    </div>
                    <div class="col-md-12 col-sm-12 col-lg-12">
                        <div class="ml-5 mt-4 float-right">
                            <button @click="search" class=" btn btn-success form-group" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i>
                                Search</button>
                            <button class="btn btn-default form-group" type="reset" id="reset">Reset</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="assignTokenModel" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Token</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="d-flex justify-content-center mb-2">

                        <input type="" name="search_username" id="search_username" class="form-control col-md-4 "
                            placeholder="Search by customer user name" autocomplete="off">



                    </div>

                    <div class="d-flex justify-content-center mb-2" id="productList">
                        <ul id="customer_list" class="sub-menu">
                        </ul>
                    </div>

                    <form action="{{ route('token-save-new') }}" method="POST">
                        @csrf
                        <div class="card">
                            <div class="card-body">

                                <div class="row">
                                    <div class="form-group col-md-3">
                                        <label for="shortname">CID</label>
                                        <input type="" name="clientId" id="clientId" class="form-control"
                                            placeholder="" autocomplete="off" readonly>
                                        @error('clientId')
                                            <div class="alert alert-danger mt-1">
                                                {{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label for="shortname">Username</label>
                                        <input id="username" name="username" class="form-control" placeholder=""
                                            autocomplete="off" readonly>
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label for="shortname">Token Category*</label>
                                        <select name="tokenCategory" id="tokenCategory" class="form-control bSelect"
                                            required>
                                            <option value="">Select Token Category</option>
                                            @foreach ($tokenCategory as $token_category)
                                                <option value="{{ $token_category->id }}">
                                                    {{ $token_category->tokenCategory }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('tokenCategory')
                                            <div class="alert alert-danger mt-1">
                                                {{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label for="shortname">Token Code*</label>
                                        <select name="tokenCode" id="tokenCode" class="form-control bSelect" required>
                                            <option value=""> Select One Code</option>
                                        </select>
                                        @error('tokenCode')
                                            <div class="alert alert-danger mt-1">
                                                {{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-group col-md-3">
                                        <label for="shortname">Reported By*</label>
                                        <input type="text" name="reportedBy" id="reportedBy" value=""
                                            class="form-control" placeholder="Reported By" autocomplete="off" required>
                                        @error('reportedBy')
                                            <div class="alert alert-danger mt-1">
                                                {{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label for="shortname">Reporter Contact No*</label>
                                        <input type="text" name="reporterContact" id="reporterContact" value=""
                                            minlength="11" maxlength="11" class="form-control"
                                            placeholder="Reporter Contact No" autocomplete="off" required>
                                        @error('reporterContact')
                                            <div class="alert alert-danger mt-1">
                                                {{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="shortname">Description*</label>
                                        <textarea type="text" name="description" rows="2" id="description" value="" class="form-control"
                                            placeholder="Description" autocomplete="off" required></textarea>
                                        @error('description')
                                            <div class="alert alert-danger mt-1">
                                                {{ $message }}</div>
                                        @enderror
                                    </div>
                                    @if (checkSettings('token_source') == 'enable')
                                        <div class="form-group col-md-3">
                                            <label>Token Source*</label>
                                            <select name="token_source" id="" class="form-control select2"
                                                required>
                                                <option value="">Select One</option>
                                                @forelse ($tokenSource as $item)
                                                    <option value="{{ $item->name }}">{{ $item->name }}</option>
                                                @empty
                                                @endforelse
                                            </select>
                                        </div>
                                    @endif
                                    @can('assign-token')
                                        <div class="form-group col-md-3">
                                            <label for="shortname">Assign To</label>
                                            <select name="employee" id="employee" class="form-control bSelect">
                                                <option value="">Select Employee</option>
                                                @foreach ($employee as $item)
                                                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    @endcan
                                </div>

                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary float-right">
                                        Save
                                    </button>
                                </div>

                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>

    <div id="result" style="min-height: 0px;">
        {{-- list will show in this box --}}
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead class="bg-dark">
                        <tr>
                            <th style="padding-left: 2px;padding-right: 2px;">ID</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:150px">Token#</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:90px">Category(Code)</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:100px">Description</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:100px">Source</th>
                            <th style="width:120px">Creator</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:120px">Customer ID <br> UserName</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:200px">Customer Info</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:70px">Reporter <br> Contact</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:70px">Assigned</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:70px">Token Type</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:70px"></th>
                        </tr>
                    </thead>
                    <tbody>
                        {{-- @dd($token) --}}
                        @foreach ($token as $r)
                            <tr>
                                <td class="token_id_of_table" style="padding-left: 2px;padding-right: 2px;">
                                    {{ $r->id }}</td>
                                {{-- <td style="padding-left: 2px;padding-right: 2px;max-width:60px">{{$r->assign_time ? "Assign time" .round(abs(strtotime($r->assign_time) - strtotime($r->created_at)) / 60,2). " m" :"Assign Pendin Time".round(abs(strtotime(now()) - strtotime($r->created_at)) / 60,2) ."m" }}</td> --}}

                                <td style="padding-left: 2px;padding-right: 2px;max-width:150px">
                                    <span class="badge badge-success"> T.ID : </span> {{ $r->token }} <br>
                                    <span class="badge badge-info"> C.T : </span>
                                    {{ date('d-M-Y g:i: a ', strtotime($r->created_at)) }} <br>
                                    @if ($r->assign_time)
                                        <span class="badge badge-warning"> A.T : </span>
                                        {{ date('d-M-Y g:i: a ', strtotime($r->assign_time)) }} <br>
                                        @if ($r->close_time)
                                            <span class="badge badge-danger"> C.T : </span>
                                            {{ date('d-M-Y g:i: a ', strtotime($r->close_time)) }} <br>
                                        @else
                                            {{ $r->close_time ? 'Closed' . dateTimeDifferent(now(), $r->assign_time) : 'Token Assigned ' . dateTimeDifferent(now(), $r->assign_time) . ' ago Not Closed' }}
                                            <br>
                                        @endif
                                    @else
                                        {{ $r->assign_time ? 'Assigned' . dateTimeDifferent(now(), $r->created_at) : 'Token Created ' . dateTimeDifferent(now(), $r->created_at) . ' ago Not assigned' }}
                                        <br>
                                    @endif

                                </td>
                                <td style="padding-left: 2px;padding-right: 2px;max-width:90px">
                                    {{ $r->category->tokenCategory ?? '' }} ({{ $r->Code->tokenCode ?? '' }})</td>
                                <td style="padding-left: 2px;padding-right: 2px;max-width:100px">{{ $r->description }}</td>
                                <td style="padding-left: 2px;padding-right: 2px;max-width:100px">
                                    @if ($r->token_source == 'CRM')
                                        <span class="btn btn-info btn-xs">{{ $r->token_source }}</span>
                                    @else
                                        {{ $r->token_source }}
                                    @endif
                                </td>
                                <td style="padding-left: 2px;padding-right: 2px;max-width:70px">
                                    {{ $r->creator->name ?? '' }}
                                    @if ($r->createByClient)
                                        <span class="badge badge-danger">{{ $r->createByClient ?? '' }}</span>
                                    @endif
                                </td>
                                <td style="padding-left: 2px;padding-right: 2px;max-width:120px">{{ $r->clientId }} <br>
                                    {{ $r->clients->userid ?? '' }}
                                </td>
                                <td style="padding-left: 2px;padding-right: 2px;max-width:200px">
                                    <p style="font-size:14px;">
                                        @if (checkAPI())
                                            @if (array_key_exists($r->clients->userid ?? '', $mikrotik_online_users['onlineUsers']))
                                                <span class="badge badge-success" title="Online">Online</span>
                                            @else
                                                <span class="btn btn-danger btn-xs" title="Online">Offline</span>
                                            @endif
                                            <br>
                                        @endif

                                        @if (!empty($r->clients->clientsInfo->clients_name))
                                            C Name : {{ $r->clients->clientsInfo->clients_name ?? '' }} <br>
                                        @endif
                                        @if (!empty($r->clients->pops->reseller->name))
                                            R Name : {{ $r->clients->pops->reseller->name ?? '' }} <br>
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->flat_no))
                                            Flat No: {{ $r->clients->clientsinfo->flat_no ?? '' }},
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->building_name))
                                            Building Name: {{ $r->clients->clientsinfo->building_name ?? '' }},<br>
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->road_no))
                                            Road No: {{ $r->clients->clientsinfo->road_no ?? '' }},<br>
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->block_sector))
                                            Block/Sector: {{ $r->clients->clientsinfo->block_sector ?? '' }},
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->area))
                                            Area : {{ $r->clients->clientsinfo->area ?? '' }}, <br>
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->box))
                                            Box : {{ $r->clients->clientsinfo->box ?? '' }}
                                        @endif
                                    </p>
                                </td>
                                <td style="padding-left: 2px;padding-right: 2px;max-width:70px">{{ $r->reportedBy }} <br>
                                    {{ $r->reporterContact }}</td>



                                <td style="padding-left: 2px;padding-right: 2px;max-width:70px">
                                    {{ $r->employees->name ?? '' }} </td>

                                <td style="padding-left: 2px;padding-right: 2px;max-width:70px">{{ $r->token_type ?? '' }}</td>

                                <td style="padding-left: 2px;padding-right: 2px;max-width:70px">
                                    <div class="dropdown">
                                        <button class="btn  dropdown-toggle" type="button" id="dropdownMenuButton"
                                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <i class="ml-3 far fas fa-list nav-icon" style="font-size: 10px"></i>
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                            @can('close-token')
                                                @if ($r->employees != null)
                                                    <button type="button" class="btn btn-info btn-small close_token_btn"
                                                        data-toggle="modal" data-target="#closeTokenModel">Close
                                                        Token</button>
                                                @endif
                                            @endcan
                                            @can('assign-token')
                                                @if ($r->employees == null)
                                                    <button type="button"
                                                        class="btn btn-block btn-info btn-small assign_token_btn"
                                                        data-toggle="modal" data-target="#searchassignTokenModel">Assign
                                                        Token</button>
                                                @else
                                                    <button type="button"
                                                        class="btn btn-block btn-info btn-small re_assign_token_btn"
                                                        data-toggle="modal" data-target="#reAssignTokenModel">Re-Assign
                                                        Token</button>
                                                @endif
                                            @endcan

                                            <button type="button" class="btn btn-block btn-info btn-small add_note"
                                                data-toggle="modal" data-target="#addNoteModel">Note</button>
                                            {{-- <button type="button" class="btn btn-block btn-small show_note" data-toggle="modal" data-target="#showNoteModel">Show Note</button> --}}
                                        </div>
                                    </div>
                                </td>

                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="modal fade" id="searchassignTokenModel" tabindex="-1" role="dialog"
        aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Assign Token</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('assignTokenFromModal') }}" method="POST" name="assign_token">
                        @csrf
                        <div class="form-group">
                            <label for="recipient-name" class="col-form-label">Empolyee:</label>
                            <select name="employee_modal" id="employee_modal" class="form-control bSelect" required>
                                <option value="">Select Employee</option>

                                @foreach ($employee as $e)
                                    <option value="{{ $e->id }}">{{ $e->name }}</option>
                                @endforeach

                            </select>
                        </div>
                        <input type="hidden" name="id_token_assign_model" id="id_token_assign_model">

                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save </button>
                    </form>
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="reAssignTokenModel" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Re Assign Token</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('reAssignTokenFromModal') }}" method="POST" name="assign_token">
                        @csrf
                        <div class="form-group">
                            <label for="recipient-name" class="col-form-label">Empolyee:</label>
                            {{-- @dd($employee) --}}
                            <select name="employee" id="employee" class="form-control bSelect" required>
                                <option value="">Select Employee</option>

                                @foreach ($employee as $e)
                                    <option value="{{ $e->id }}">{{ $e->name }}</option>
                                @endforeach

                            </select>
                        </div>
                        <input type="hidden" name="id_token_re_assign_model" id="id_token_re_assign_model">

                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save </button>
                    </form>
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="closeTokenModel" tabindex="-1" role="dialog" aria-labelledby="closeTokenModel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Close Token</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('closeTokenModal') }}" method="POST" name="assign_token">
                        @csrf
                        <div class="form-group">
                            <label for="recipient-name" class="col-form-label">Remark*</label>
                            <input type="text" name="remark" id="remark" class="form-control" required>
                        </div>
                        @if (checkSettings('remote_autoreboot_info_required') == 'enable')
                            <div class="form-group">
                                <label for="recipient-name"
                                    class="col-form-label">Remote{{ checkRequired('remote_autoreboot_info_required', '*') }}</label>
                                <select name="remote" id="" class="form-control"
                                    {{ checkRequired('remote_autoreboot_info_required', 'required') }}>
                                    <option value="0">No</option>
                                    <option value="1">Yes</option>
                                </select>
                            </div>
                        @endif

                        <div class="form-group">
                            <label for="ping_loss" class="col-form-label">Ping
                                Loss{{ checkRequired('ping_optical_info_required', '*') }}</label>
                            <input type="text" name="ping_loss" id="ping_loss" class="form-control"
                                {{ checkRequired('ping_optical_info_required', 'required') }}>
                        </div>
                        @if (checkSettings('remote_autoreboot_info_required') == 'enable')
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Auto
                                    Reboot{{ checkRequired('remote_autoreboot_info_required', '*') }}</label>
                                <select name="autoreboot" id="" class="form-control"
                                    {{ checkRequired('remote_autoreboot_info_required', 'required') }}>
                                    <option value="0">No</option>
                                    <option value="1">Yes</option>
                                </select>
                            </div>
                        @endif

                        <div class="form-group">
                            <label for="optical_power" class="col-form-label">Optical
                                Power{{ checkRequired('ping_optical_info_required', '*') }}</label>
                            <input type="text" name="optical_power" id="optical_power" class="form-control"
                                {{ checkRequired('ping_optical_info_required', 'required') }}>
                        </div>

                        <div class="form-group">
                            <label for="issue_type">Issue Type*</label>
                            <div class="row">
                                <div class="col-md-6">
                                    <input type="radio" id="physical" name="issue_type" value="Physical" required>
                                    <label for="physical">Physical</label><br>
                                </div>
                                <div class="col-md-6">
                                    <input type="radio" id="logical" name="issue_type" value="Logical" required>
                                    <label for="logical">Logical</label><br>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="client_feedback" class="col-form-label">Client Feedback*</label>
                            <textarea name="client_feedback" class="form-control" required></textarea>
                        </div>

                        <input type="hidden" name="id_token_close_model" id="id_token_close_model">

                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save </button>
                    </form>
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="addNoteModel" tabindex="-1" role="dialog" aria-labelledby="closeTokenModel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Note</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="table-responsive" style="height: 300px">
                        <table id="token_note_table" class="table table-bordered">
                            <thead class="bg-dark">
                                <tr>
                                    <th style="max-width: 100px">Id</th>
                                    <th style="max-width: 100px">Note For</th>
                                    <th style="max-width: 100px">Created Time</th>
                                    <th>Remark</th>
                                    <th>Created By</th>
                                    @can('token-note-delete')
                                        <th style="max-width: 100px">Action</th>
                                    @endcan
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                    <form action="{{ route('add-note-token') }}" method="POST" name="assign_token">
                        @csrf
                        <div class="form-group">
                            <label for="recipient-name" class="col-form-label">Note For</label>
                            <select name="note_for" id="note_for" class="form-control">
                                <option value="employee">Employee</option>
                                <option value="customer">Customer</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="recipient-name" class="col-form-label">Remark</label>
                            <textarea type="text" name="note_remark" id="note_remark" class="form-control"></textarea>
                        </div>
                        <input type="hidden" name="add_modal_token_id" id="add_modal_token_id">

                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save </button>
                    </form>
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>

    {{-- <div class="modal fade" id="showNoteModel" tabindex="-1" role="dialog" aria-labelledby="closeTokenModel"
            aria-hidden="true">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabelshow">Show Note</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body" >
                        <div class="table-responsive" style="height: 300px">
                            <table id="token_note_table_show" class="table table-bordered">
                                <thead class="bg-dark">
                                    <tr>
                                        <th style="max-width: 100px">Id</th>
                                        <th style="max-width: 100px">Note For</th>
                                        <th style="max-width: 100px">Created Time</th>
                                        <th>Remark</th>
                                        <th>Created By</th>
                                        <th style="max-width: 100px">Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>

                    </div>
                    <div class="modal-footer">
                    </div>
                </div>
            </div>
        </div> --}}

    <style>
        .sub-menu li {
            font-size: 1em;
            padding: .25em 1em;
            line-height: 1em;
        }

        .sub-menu {
            padding: 0;
            max-height: 200px;
            /* 1.5 x 3 */
            overflow-y: auto;
        }

        li.selected {
            background: #17A2B8 !important;
        }
    </style>
@endsection

@section('ajax')
    <script type="text/javascript">
        $(function() {
            $('#reset').click(function() {
                $('#result').html('');
                window.location.reload();
            });
            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $.ajax({
                    type: 'get',
                    url: '{{ route('searchTokenResult') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);

                    }
                });
            });

            $('#details').on('click', function(e) {
                e.preventDefault();
                $.ajax({
                    type: 'get',
                    url: '{{ route('searchTokenResult') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);

                    }
                });
            });

            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="processing">processing.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerPopList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#processing').remove();
                    }
                });
            });

            $('#tokenCategory').change(function() {
                var tokenCategory = $(this).val();
                if (tokenCategory) {
                    $.ajax({
                        type: "GET",
                        url: '{{ route('get-token-code') }}',
                        data: {
                            tokenCategory: tokenCategory
                        },
                        success: function(res) {
                            if (res) {
                                $("#tokenCode").empty();
                                $("#tokenCode").append('<option>Select One Code</option>');
                                res.forEach(element => {
                                    $("#tokenCode").append('<option value="' + element
                                        .id + '">' + element.tokenCode + '</option>'
                                    );
                                });


                            } else {
                                $("#tokenCode").empty();
                            }
                        }
                    });
                } else {
                    $("#tokenCode").empty();
                }
            });

            function addCustomerInlist(id, customer_name, customer_mobile, userid) {
                if (customer_name == null) {
                    customer_name = '';
                }
                if (customer_mobile == null) {
                    customer_mobile = '';
                }
                $("#customer_list").append(
                    '<li class="list-group-item list-group-item-dark customer_li" style="background-color:skyblue;">' +
                    '<div class="row">' +
                    '<p><strong> ' + customer_name + '-(' + customer_mobile + ')</strong><br>' +
                    '<b >UserId: </b>' + userid + '<br>' +
                    '</p>' +
                    '<div class="col-md-6"><input type="hidden" class="customer_id" value="' + id +
                    '" name="reference_no" placeholder="Enter Name" ></div>' +
                    '<div class="col-md-6"><input type="hidden" class="customer_user_name" value="' + userid +
                    '" name="reference_no" placeholder="Enter Name" ></div>' +
                    '<div class="col-md-6"><input type="hidden" class="customer_name" value="' + customer_name +
                    '" name="reference_no" placeholder="Enter Name" ></div>' +
                    '<div class="col-md-6"><input type="hidden" class="customer_mobile" value="' +
                    customer_mobile + '" name="reference_no" placeholder="Enter Name" ></div>' +
                    '</div>' +
                    '</li>');
            }

            $("#search_username").keyup(function() {
                var search = $(this).val();
                if (search.length >= 2) {
                    // console.log(search.length);
                    $.ajax({
                        url: '{{ route('get-customer') }}',
                        method: "GET",
                        data: {
                            search: search
                        },
                        success: function(data) {
                            $("#customer_list").empty();
                            data.forEach(element => {
                                addCustomerInlist(element.id, element.clientsinfo
                                    .clients_name, element.clientsinfo.contact_no,
                                    element.userid);
                            });
                        }
                    });
                } else {
                    $("#customer_list").empty();

                }

            });

            $(document).on('click', '.customer_li', function() {
                var customer_cid = $(this).find('.customer_id').val();
                var customer_user_name = $(this).find('.customer_user_name').val();
                var customer_name = $(this).find('.customer_name').val();
                var customer_mobile = $(this).find('.customer_mobile').val();

                $("#clientId").val(customer_cid);
                $("#username").val(customer_user_name);
                $("#reportedBy").val(customer_name);
                $("#reporterContact").val(customer_mobile);
                $("#customer_list").empty();
                // $('#description').focus();
            });


            function addToTokenNoteTable(id, note, created_by, type, created_at) {

                let note_for = type;
                if (type == 'employee') {
                    note_for = 'Employee';
                } else {
                    note_for = 'Customer';
                }
                let d = moment(created_at).format('YYYY-MM-DD hh:mm:ss A');

                $('#token_note_table tbody').append(
                    '<tr>' +
                    '<td>' + id + '</td>' +
                    '<td><strong >' + note_for + '</strong></td>' +
                    '<td>' + d + '</td>' +
                    '<td>' + note + '</td>' +
                    '<td>' + created_by + '</td>' +
                    '</tr>'
                );
            }


            $(document).on('click', '.add_note', function() {
                var token_id = $(this).parents("tr").find(".token_id_of_table").text();

                $.ajax({
                    type: "GET",
                    url: '{{ route('get-token-note') }}',
                    data: {
                        token_id: token_id
                    },
                    success: function(res) {

                        $('#token_note_table tbody').empty();
                        let list = res.token_notes;
                        let delete_permission = res.token_note_delete;
                        list.forEach(element => {
                            addToTokenNoteTable(element.id, element.note, element.user
                                .name, element.note_type, element.created_at);
                        });


                    }

                });
            });


        });
    </script>
    <script>
        $(document).ready(function() {
            $('.assign_token_btn').click(function() {
                var token_id = $(this).parents("tr").find(".token_id_of_table").text();
                // console.log(token_id);
                $('#id_token_assign_model').val(token_id);
            });

            $('.close_token_btn').click(function() {
                var token_id = $(this).parents("tr").find(".token_id_of_table").text();
                // console.log(token_id);
                $('#id_token_close_model').val(token_id);
            });

            $('.re_assign_token_btn').click(function() {
                var token_id = $(this).parents("tr").find(".token_id_of_table").text();
                // console.log(token_id);
                $('#id_token_re_assign_model').val(token_id);
            });

            $('.add_note').click(function() {
                var token_id = $(this).parents("tr").find(".token_id_of_table").text();
                $('#add_modal_token_id').val(token_id);
                $.ajax({
                    type: "GET",
                    url: '{{ route('get-token-note') }}',
                    data: {
                        token_id: token_id
                    },
                    success: function(res) {

                        $('#token_note_table tbody').empty();
                        let list = res.token_notes;
                        let delete_permission = res.token_note_delete;
                        list.forEach(element => {
                            addToTokenNoteTable(element.id, element.note, element.user
                                .name, element.note_type, element.created_at,
                                delete_permission);
                        });


                    }

                });
            });
        })
    </script>
@endsection
