<?php ($permissions = userPermissions()); ?>


<?php $__env->startSection('content'); ?>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title" style="color:#115548;"><i class="fa fa-search"></i> Missing Monthly Bill Generate Report
                            </h3>
                        </div>

                        <div class="card-body">

                            <form action="" id="search">
                                <div class="row">

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                                From Date
                                            </label>
                                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                                <input type="text" name="from_date" value="<?php echo e($start->format('m/d/y')); ?>" class="form-control datetimepicker-input input-group-append"
                                                    data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">

                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                                To Date
                                            </label>
                                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                                <input type="text" name="to_date" value="<?php echo e($end->format('m/d/y')); ?>"
                                                    class="form-control datetimepicker-input input-group-append"  data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3">
                                        <div class="form-group">
                                            <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Select
                                                Manager</label>
                                            <select name="reseller_id" id="reseller_id" class="select2 form-control">
                                                <option value="">All Reseller</option>
                                                <?php $__currentLoopData = $reseller; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($r->id); ?>"><?php echo e($r->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3">
                                        <div class="form-group">
                                            <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Select
                                                Sub-Manager/Pop</label>
                                            <select name="pop_id" id="pop" class="select2 form-control">
                                                <option value="">All Pops/Sub-manager</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group float-right mt-2">
                                            <button class="btn btn-primary" type="submit" id="searchBtn"><i class="fa fa-search"></i> Search</button>
                                        </div>
                                    </div>


                                </div>
                            </form>
                            <br>
                            <div class="col-md-12" id="result">
                                <button class="btn btn-primary mb-2" onclick="export2csv()">Download csv</button>
                                <table class="table table-striped table-borderless table-condensed" id="result_table">
                                    <thead>
                                        <tr class="bg-black">
                                            <th>ID</th>
                                            <th>User name</th>
                                            <th>Status</th>
                                            <th>Expire</th>
                                            <th>Package</th>
                                            <th>Package Price</th>

                                            <th>POP</th>
                                            <th>Name</th>
                                            <th>Contact</th>
                                            <th>Client Info</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                            <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr >

                                                <td class="text-center">
                                                    <a class=" btn-info btn-block btn-xs text-nowrap clear"
                                                            href="<?php echo e(route('getPaymentHistory', $r->id)); ?>">CID: <?php echo e($r->id); ?></a>
                                                </td>
                                                <td class="no-wrap">
                                                    <?php echo e($r->userid); ?>


                                                </td>

                                                <td class="cStatus<?php echo e($r->id); ?> <?php echo e(clientStatusClass($r->clients_status)); ?> ">

                                                    <?php if($r->clients_status == 'active'): ?>
                                                        Active
                                                    <?php elseif($r->clients_status == 'deactive'): ?>
                                                        Deactive</span>
                                                    <?php elseif($r->clients_status == 'expired'): ?>
                                                        Expired</span>
                                                    <?php elseif($r->clients_status == 'disable'): ?>
                                                        Disabled</span>
                                                    <?php endif; ?>

                                                </td>
                                                <td class="cExpireDate<?php echo e($r->id); ?> <?php echo e(clientStatusClass($r->clients_status)); ?>"
                                                    style="min-width:140px;text-align:left">
                                                    BD: <?php echo e(date('d-M-Y', strtotime($r->expire_date))); ?><br>
                                                    <?php if($r->payment_dadeline != 0): ?>
                                                        <span class="d-block badge badge-warning">
                                                            PD: <?php echo e(\Carbon\Carbon::parse($r->expire_date)->addDay($r->payment_dadeline)->format('d-M-Y')); ?>

                                                        </span>
                                                    <?php else: ?>
                                                            PD: <?php echo e(\Carbon\Carbon::parse($r->expire_date)->addDay($r->payment_dadeline)->format('d-M-Y')); ?>

                                                    <?php endif; ?>
                                                </td>


                                                <td>

                                                    <?php if(in_array('show-sub-package', $permissions)): ?>
                                                        <span class="d-block mb-1 badge badge-info"><?php echo e($r->subpack->name ?? ''); ?> </span>
                                                    <?php endif; ?>


                                                    <?php if(in_array('show-mother-package', $permissions)): ?>
                                                        <span class="d-block badge badge-info"> <?php echo e($r->packages->package_name ?? ''); ?> </span>
                                                    <?php endif; ?>

                                                </td>

                                                <td>
                                                    <?php if(in_array('show-sub-package', $permissions)): ?> Sub package price :  <?php echo e($r->subpack->rate ?? '0.00'); ?>   <?php endif; ?>
                                                    <br>  <?php if(in_array('show-mother-package', $permissions)): ?> Package price :  <?php echo e($r->packages->package_rate ?? '0.00'); ?> <?php endif; ?>
                                                    <br> Permanent Discount: <?php echo e($r->parmanent_discount ?? '0.00'); ?>

                                                    <br>  <?php if($r->is_free == 1): ?>
                                                            <p class="badge badge-info m-0">Free</p>
                                                        <?php endif; ?>

                                                </td>

                                                <td class="no-wrap">
                                                    <?php if($r->pops->experity_check == 'Yes'): ?>
                                                        <span class="d-block badge badge-warning">
                                                            <?php echo e($r->pops->popname ?? ''); ?>

                                                        </span>
                                                    <?php else: ?>
                                                        <?php echo e($r->pops->popname ?? ''); ?>

                                                    <?php endif; ?>
                                                </td>

                                                <td>
                                                    <?php echo e($r->clientsinfo->clients_name ?? ''); ?>

                                                </td>
                                                <td>
                                                    <?php echo e($r->clientsinfo->contact_no ?? ''); ?>

                                                </td>



                                                <td style="width:350px;font-size:14px">
                                                    <?php if($r->ip_address): ?>
                                                        IP: <?php echo e($r->ip_address ?? ''); ?>,
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->flat_no): ?>
                                                        Flat No: <?php echo e($r->clientsinfo->flat_no ?? ''); ?>,
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->building_name): ?>
                                                        Building Name: <?php echo e($r->clientsinfo->building_name ?? ''); ?>,<br>
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->building_no): ?>
                                                        Building No: <?php echo e($r->clientsinfo->building_no ?? ''); ?>,<br>
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->road_name): ?>
                                                        Road Name: <?php echo e($r->clientsinfo->road_name ?? ''); ?>,<br>
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->road_no): ?>
                                                        Road No: <?php echo e($r->clientsinfo->road_no ?? ''); ?>,<br>
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->block_sector): ?>
                                                        Block/Sector: <?php echo e($r->clientsinfo->block_sector ?? ''); ?>,<br>
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->area): ?>
                                                        Area :<?php echo e($r->clientsinfo->area ?? ''); ?>,<br>
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->box): ?>
                                                        Box :<?php echo e($r->clientsinfo->box ?? ''); ?>,<br>
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->cable_type): ?>
                                                        Cable Type :<?php echo e($r->clientsinfo->cable_type ?? ''); ?>,<br>
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->olt_pon): ?>
                                                        OLT/PON : <?php echo e($r->clientsinfo->olt_pon ?? ''); ?>,<br>
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->other_contact): ?>
                                                        Other Contact : <?php echo e($r->clientsinfo->other_contact ?? ''); ?>,<br>
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->email): ?>
                                                        <br>
                                                        <b class="text-primary">Email :</b> <?php echo e($r->clientsinfo->email ?? ''); ?>,<br>
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->client_latitude): ?>
                                                        Latitude : <?php echo e($r->clientsinfo->client_latitude ?? ''); ?>,<br>
                                                    <?php endif; ?>

                                                    <?php if($r->clientsinfo->client_longitude): ?>
                                                        Longitude : <?php echo e($r->clientsinfo->client_longitude ?? ''); ?>,<br>
                                                    <?php endif; ?>


                                                    <?php if($r->required_cable): ?>
                                                        Cable(Meter): <?php echo e($r->required_cable ?? ''); ?>,<br>
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->cat_length): ?>
                                                        CAT-5/CAT-6 Length(Meter): <?php echo e($r->clientsinfo->cat_length ?? ''); ?>,<br>
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->onu_serial): ?>
                                                        ONU MAC/Pon No/Serial No: <?php echo e($r->clientsinfo->onu_serial ?? ''); ?>,<br>
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->olt_pon): ?>
                                                        OLT No: <?php echo e($r->clientsinfo->olt_pon ?? ''); ?>,<br>
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->olt_no): ?>
                                                        OLT Card Slot No: <?php echo e($r->clientsinfo->olt_no ?? ''); ?>,<br>
                                                    <?php endif; ?>
                                                    <?php if($r->clientsinfo->pon_port): ?>
                                                        PON Module Port No: <?php echo e($r->clientsinfo->pon_port ?? ''); ?>

                                                    <?php endif; ?>

                                                </td>

                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td><strong>Total</strong></td>
                                            <td><strong><?php echo e($clients->count()); ?></strong></td>
                                        </tr>
                                    </tfoot>

                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('ajax'); ?>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#searchBtn').click(function(e) {
                e.preventDefault();
                $('body').prepend('<div id="loading">Loading.....</div>');
                $.ajax({
                    type: 'get',
                    url: '<?php echo e(route('missing-bill-generate-search')); ?>',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $('#loading').remove();

                    }
                });
            });
        });

        function export2csv() {
            let data = "";
            const tableData = [];
            const rows = document.querySelectorAll("table#result_table tr");
            for (const row of rows) {
                const rowData = [];
                for (const [index, column] of row.querySelectorAll("th, td").entries()) {

                    rowData.push(column.innerText.replace(/[\r\n]/gm, ' '));
                }
                tableData.push(rowData.join(","));
            }
            data += tableData.join("\n");
            const a = document.createElement("a");
            a.href = URL.createObjectURL(new Blob([data], { type: "text/csv" }));
            a.setAttribute("download", "missing_bill_generate.csv");
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        $('#reseller_id').on('change', function() {
            $("#loader").show();
            $.ajax({
                type: 'get',
                url: '<?php echo e(route('getPopForManager')); ?>',
                data: {
                    id: $(this).val()
                },
                success: function(data) {
                    $('#pop option').remove();
                    $('#pop').append(data);
                    $("#loader").hide();
                }
            });
        });

    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/mondol/radius-circle/resources/views/billGenerateReport/missingBillgenrate.blade.php ENDPATH**/ ?>