<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePortMapTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('port_map', function (Blueprint $table) {
            $table->id();
            $table->timestamps();

            $table->string("label")->nullable();
            $table->integer("port_number");
            $table->enum("port_type", ["1g", "10g", "40g", "100g", "pon", "xpon", "other"]);
            $table->string("type")->default("port");

            $table->foreignId("device_id");
            $table->enum("port_stream", ["incoming", "outgoing"])->default("outgoing");

            $table->foreignId("fiber_id")->nullable();
            $table->foreignId("cable_id")->nullable();

            $table->foreignId("connected_component_id")->nullable();
            $table->string("connected_component_type")->nullable();

            $table->integer("pon_count")->default(0);
            $table->enum("pon_limit", [64, 128])->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('port_map');
    }
}
