<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('voice_broadcasts')) {
            return;
        }

        Schema::table('voice_broadcasts', function (Blueprint $table) {
            $table->string('status')->default('enabled')->after('disk');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (!Schema::hasTable('voice_broadcasts')) {
            return;
        }

        Schema::table('voice_broadcasts', function (Blueprint $table) {
            $table->dropColumn('status');
        });
    }
};

