@extends('layout.app')


@section('content')
    <div class="row">
        <div class="col-sm-4">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('rechargeUpdate') }}" method="POST">
                        @csrf


                        <p class="p-2">Manager Name: {{ $reseller->name }}</p>
                        <p class="p-2">Current Balance: {{ $reseller->balance[0]['amount'] ?? 0 }}</p>
                        <p class="p-2 font-weight-bold text-danger">Maximum amount can recharge :
                            {{ 999999.99 - ($reseller->balance[0]['amount'] ?? 0) }}</p>
                        <input type="hidden" id="uuid" name="uuid" value="{{ createUUID() }}">

                        <div class="form-group">
                            <label for="amount">Amount</label>

                            <input type="number" name="amount" placeholder="0" class="form-control" required>
                            @error('amount')
                                <div class="text-red-500 mt-2 text-sm">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group d-none">
                            <label for="amount">Recharge Type</label>

                            <select name="recharge_type" class="form-control" required>
                                <option value="cash" selected>Cash</option>
                            </select>
                            @error('recharge_type')
                                <div class="text-red-500 mt-2 text-sm">{{ $message }}</div>
                            @enderror
                        </div>

                        @if (checkSettings('reseller-recharge-paid-option') == 'enable')
                            <div class="form-group">
                                <label for="amount">Paid Amount</label>

                                <input type="number" name="paid_amount" placeholder="0" class="form-control" required>
                                @error('paid_amount')
                                    <div class="text-red-500 mt-2 text-sm">{{ $message }}</div>
                                @enderror

                            </div>
                        @endif






                        <div class="form-group">

                            <label for="remark">Remark*</label>
                            <input type="text" name="remark" class="form-control" required>
                            @error('remark')
                                <div class="text-red-500 mt-2 text-sm">{{ $message }}</div>
                            @enderror

                        </div>




                        <input type="hidden" value="{{ $reseller->id }}" name="type_id">
                        <input type="hidden" value="reseller" name="type">
                        <div class="from-group">
                            <a href="{{ route('resellers.index') }}" class="btn btn-default float-lef"><i
                                    class="fa fa-arrow-left"></i> Back</a>
                            <button class="btn btn-primary float-right " type="submit">Recharge</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-sm-8">
            <div class="card">
                <div class="card-body">
                    <p class="p-2">Manager Recharge History </p>

                    <div class="form-group">
                        <div class="table-responsive">
                            <table class="table table-borderd table-striped">
                                <thead class="bg-blue-50">
                                    <tr>

                                        <th>
                                            Date
                                        </th>

                                        <th class="text-right">
                                            Recharge Amount
                                        </th>

                                        <th class="text-right">
                                            After Recharge Balance
                                        </th>
                                        @if (checkSettings('reseller-recharge-paid-option') == 'enable')
                                            <th class="text-right">Paid Amount</th>
                                        @endif

                                        <th>
                                            Remarks
                                        </th>
                                        <th>
                                            Recharge By
                                        </th>
                                        <th>

                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="
                                        bg-white divide-y divide-gray-200">
                                    @foreach ($rechargeList as $r)
                                        <tr>

                                            <td>
                                                {{ date('d-M-Y h:i:sa', strtotime($r->created_at)) }}
                                            </td>



                                            <td class="text-right">
                                                {{ $r->amount }}
                                            </td>


                                            <td class="text-right">
                                                {{ $r->after_recharge_balance }}
                                            </td>
                                            @if (checkSettings('reseller-recharge-paid-option') == 'enable')
                                                <td class="text-right">{{ $r->paid_amount }}</td>
                                            @endif

                                            <td>
                                                {{ $r->remarks }}
                                            </td>
                                            <td>
                                                {{ $r->user->name ?? '' }}
                                            </td>


                                        </tr>
                                    @endforeach

                                    <tr class="bg-info">
                                        <td class="text-right">Total Recharge: </td>
                                        <td class="text-right">{{ $rechargeList->sum('amount') }}</td>
                                        @if (checkSettings('reseller-recharge-paid-option') == 'enable')
                                            <td class="text-right">Total Paid: </td>
                                            <td class="text-right">{{ $rechargeList->sum('paid_amount') }}</td>
                                        @endif
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>





                    </div>
                </div>
            </div>
        </div>

    </div>


@endsection

@push('js')
<script>
    $(function() {
        $('.recharge').on('click', function() {
            if (confirm('Are you sure to recharge?')) {
                return true;
            }
        });
    });
</script>
@endpush
