<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Map\ClusterController;
use App\Http\Controllers\Map\CableController;
use App\Http\Controllers\Map\ConnectivityController;
use App\Http\Controllers\Map\DeviceController;
use App\Http\Controllers\Map\MapClientController;
use App\Http\Controllers\Map\SplitterController;
use App\Http\Controllers\Map\OnuController;
use App\Http\Controllers\Map\TjBoxController;
use App\Models\Pop;
use Illuminate\Support\Facades\DB;

Route::prefix("clients")->group(function () {
    Route::get("getOnlyStatus", [MapClientController::class, "getOnlyClientsStatus"]);
    Route::get("getClientDetail/{client_id}", [MapClientController::class, "getClientDetail"]);
});

Route::prefix("clusters")->group(function () {

    Route::get("/", [ClusterController::class, "index"]);
    Route::post("/", [ClusterController::class, "store"]);


    Route::get("/{cluster}", [ClusterController::class, "show"])->name("clusters.show");
    Route::put("/{cluster}", [ClusterController::class, "update"]);
    Route::delete("/{cluster}", [ClusterController::class, "destroy"]);

    Route::get("/{cluster}/clients", [ClusterController::class, "getClusterClients"]);

    Route::delete("/clients/{client_id}/disconnect", [ClusterController::class, "disconnectClient"]);
});

Route::prefix("boxes")->group(function () {
    Route::get("/", [ClusterController::class, "getAllBoxes"])->name("boxes.index");
    Route::get("/coordinates/{box_id}", [ClusterController::class, "getBoxCordinates"])->name("boxes.coordinates");
});

Route::prefix("cables")->group(function () {
    Route::get("/", [CableController::class, "index"]);
    Route::post("/", [CableController::class, "store"]);
    Route::get("/{cable}", [CableController::class, "show"]);
    Route::put("/{cable}", [CableController::class, "update"]);
    Route::delete("/{cable}", [CableController::class, "destroy"]);

    Route::get("/{cable}/detail", [CableController::class, "cableDetail"]);

    Route::post("/connect-fiber", [CableController::class, "connectFiber"]);
    Route::delete("/disconnect-fiber/{fiber}", [CableController::class, "disconnectFiber"]);
});

Route::prefix("devices")->group(function () {
    Route::get("/", [DeviceController::class, "index"]);
    Route::post("/", [DeviceController::class, "store"]);
    Route::get("/{device}", [DeviceController::class, "show"]);
    Route::put("/{device}", [DeviceController::class, "update"]);
    Route::delete("/{device}", [DeviceController::class, "destroy"]);

    Route::get("/{device}/detail", [DeviceController::class, "deviceDetail"]);

    Route::patch("/update-ports/{port}", [DeviceController::class, "updatePortDetail"]);
    Route::delete("/disconnect-port/{portId}", [DeviceController::class, "disconnectPort"]);
});

Route::prefix("splitters")->group(function () {
    Route::get("/", [SplitterController::class, "index"]);
    Route::post("/", [SplitterController::class, "store"]);
    Route::get("/{splitter}", [SplitterController::class, "show"]);
    Route::put("/{splitter}", [SplitterController::class, "update"]);
    Route::delete("/{splitter}", [SplitterController::class, "destroy"]);

    Route::delete("/{splitter}/disconnect-parent", [SplitterController::class, "disconnectParentComponent"]);
    Route::delete("/disconnect-child/{splitter_out}", [SplitterController::class, "disconnectChildComponent"]);
});

Route::prefix("onus")->group(function () {
    Route::get("/", [OnuController::class, "index"]);
    Route::post("/", [OnuController::class, "store"]);
    Route::get("/{onu}", [OnuController::class, "show"]);
    Route::put("/{onu}", [OnuController::class, "update"]);
    Route::delete("/{onu}", [OnuController::class, "destroy"]);

    Route::get("/{onu}/detail", [OnuController::class, "detail"]);

    Route::delete("/disconnect/{onu}", [OnuController::class, "disconnectComponent"]);
});

Route::prefix("tj-boxes")->group(function () {
    Route::get("/", [TjBoxController::class, "index"]);
    Route::post("/", [TjBoxController::class, "store"]);
    Route::get("/{tjBox}", [TjBoxController::class, "show"]);
    Route::put("/{tjBox}", [TjBoxController::class, "update"]);
    Route::delete("/{tjBox}", [TjBoxController::class, "destroy"]);
});

Route::prefix("pops")->group(function () {
    Route::get("/", function () {
        return  Pop::whereNotNull("longitude")
            ->whereNotNull("latitude")
            ->whereRaw("longitude REGEXP '^-?[0-9]+(\\.[0-9]+)?$'")
            ->whereRaw("latitude REGEXP '^-?[0-9]+(\\.[0-9]+)?$'")
            ->whereRaw("longitude REGEXP '^-?[0-9]*\\.?[0-9]+$'")
            ->whereRaw("latitude REGEXP '^-?[0-9]*\\.?[0-9]+$'")
            ->whereRaw("NOT (CAST(latitude AS DECIMAL(10,8)) = 0 AND CAST(longitude AS DECIMAL(11,8)) = 0)")
            ->get(["popname", "id", "longitude", "latitude"]);
    });
});

Route::prefix("connect")->group(function () {
    Route::post("/", [ConnectivityController::class, "connect"]);
});
