<div class="print-content" id="result">

    <table class="table table-bordered table-condensed table-striped" id="tableId">
        <thead class="bg-dark text-white">
            <tr>
                <th>Manager Id</th>
                <th>Manager Name</th>
                <th>Manager Type</th>
                <th>New Id (Active)</th>
                <th>Updated Id (Active)</th>
                <th>New Id (Not Active)</th>
                <th>Updated Id (Not Active)</th>

            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-200">
            @php
                use App\Models\Pop;

                $managerIsNewOrOld = '';

                $total_active_clients_new = 0;
                $total_active_clients_old = 0;
                $total_not_active_clients_new = 0;
                $total_not_active_clients_old = 0;

            @endphp

            @foreach ($users->resellers as $reseller)
                @php

                    $new_resellers_ids = $users
                        ->resellers()
                        ->whereBetween('resellers.created_at', [$start, $end])
                        ->where('resellers.id', $reseller->id)
                        ->first();

                    $pops = Pop::where('reseller_id', $reseller->id)->pluck('id');

                    $active_clients = $clients->whereIn('pop_id', $pops)->where('clients_status', 'active')->count();

                    $not_active_clients = $clients
                        ->whereIn('pop_id', $pops)
                        ->where('clients_status', '!=', 'active')
                        ->count();

                    if ($new_resellers_ids == null) {
                        $managerIsNewOrOld = 'Old';
                        $total_active_clients_old += $active_clients;
                        $total_not_active_clients_old += $not_active_clients;
                    } else {
                        $managerIsNewOrOld = 'New';
                        $total_active_clients_new += $active_clients;
                        $total_not_active_clients_new += $not_active_clients;
                    }

                @endphp
                <tr>
                    <td>{{ $reseller->id }}</td>
                    <td>{{ $reseller->name }} </td>
                    <td>{{ $managerIsNewOrOld }}</td>
                    @if ($managerIsNewOrOld == 'Old')
                        <td>0</td>
                        <td>{{ $active_clients }}</td>
                        <td>0</td>
                        <td>{{ $not_active_clients }}</td>
                    @else
                        <td>{{ $active_clients }}</td>
                        <td>0</td>
                        <td>{{ $not_active_clients }}</td>
                        <td>0</td>
                    @endif

                </tr>
            @endforeach
            <tr>
                <td colspan="3"><b>Total ({{ $users->resellers->count() }})</td>
                <td><b>{{ $total_active_clients_new }}</b></td>
                <td><b>{{ $total_active_clients_old }}</b></td>
                <td><b>{{ $total_not_active_clients_new }}</b></td>
                <td><b>{{ $total_not_active_clients_old }}</b></td>
            </tr>

        </tbody>
    </table>
</div>
