<?php

namespace App\Jobs;

use App\Services\BatchExpChangeService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class BatchPackChangeJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $clients;
    private $auth_user;
    private $pack;
    public function __construct($clients, $auth_user, $pack)
    {
        $this->clients = $clients;
        $this->auth_user = $auth_user;
        $this->pack = $pack;
    }

    public function handle()
    {
        foreach ($this->clients as $user) {
            echo $user->id . '<br>';
            (new BatchExpChangeService)->batchPackChange($user, $this->auth_user, $this->pack);
        }
    }
}
