<?php

namespace App\Http\Controllers;

use App\Models\PaymentMethod;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;

class PaymentMethodController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data=[
            'payment_methods' => PaymentMethod::all(),
        ];
        return view('paymentMethod.index', $data);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('paymentMethod.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:payment_methods',

        ]);

        $payment_method = new PaymentMethod;
        $payment_method->name = $request->name;
        $payment_method->status = $request->status;
        $payment_method->api_key = $request->api_key;
        $payment_method->save();
        Toastr::success('Payment Method Successfully Saved ' ,'Success');
        return redirect()->route('payment-method.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data=[
            'payment_method' => PaymentMethod::find($id),
        ];
        return view('paymentMethod.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required|unique:payment_methods,name,'.$id,
        ]);

        $payment_method = PaymentMethod::find($id);
        $payment_method->name = $request->name;
        $payment_method->status = $request->status;
        $payment_method->api_key = $request->api_key;
        $payment_method->save();
        Toastr::success('Payment Method Successfully Updated ' ,'Success');
        return redirect()->route('payment-method.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
