<?php

namespace App\Http\Controllers;

use App\Models\Supplier;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SupplierController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:supplier_create|supplier_index',['only' => 'create','index']);
        $this->middleware('permission:supplier_create',['only' => 'create']);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = Supplier::paginate('100');
        return view('supplier.index',[
            'page_title' => 'Supplier List',
            'list' => $list,
            'url' => route('supplier.create'),
            'add_button' => 'true',
            'class' => 'btn btn-primary',
            'value' => 'Add New Supplier'
             ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('supplier.create',[
            'page_title'=> 'Add New Supplier'
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
          //  dd($request->all());
          $this->validate($request, [
            'name' => 'required',
            'mobile' => 'required|unique:suppliers',
            'alt_mobile' => 'required',
            'email' => 'required|unique:suppliers',
            'remarks' => 'nullable',
        ]);

        $supplier = new Supplier();
        $supplier->fill($request->all());
        $supplier->creator_user_id = Auth::id();
        $supplier->slug = $request->mobile.'/'.Str::slug($request->name);
        $supplier->save();
        $request->session()->flash('success_message', 'Supplier Added successful');
        return redirect()->route('supplier.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Supplier  $supplier
     * @return \Illuminate\Http\Response
     */
    public function show(Supplier $supplier)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Supplier  $supplier
     * @return \Illuminate\Http\Response
     */
    public function edit(Supplier $supplier)
    {
        return view('supplier.update',[
            'list' => $supplier,
            'page_title' => 'Update Supplier Information'
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Supplier  $supplier
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Supplier $supplier)
    {
        $this->validate($request, [
            'name' => 'required',
            'mobile' => 'required|unique:suppliers,mobile,' . $supplier->id,
            'alt_mobile' => 'required',
            'email' => 'required|unique:suppliers,email,' . $supplier->id,
            'remarks' => 'nullable',
        ]);

        $supplier->contact_person_name = $request->contact_person_name;
        $supplier->contact_person_mobile = $request->contact_person_mobile;
        $supplier->name = $request->name;
        $supplier->slug = Str::slug($request->name);
        $supplier->email = $request->email;
        $supplier->mobile = $request->mobile;
        $supplier->alt_mobile = $request->alt_mobile;
        $supplier->division_id = $request->division_id;
        $supplier->district_id = $request->district_id;
        $supplier->upazila_id = $request->upazila_id;
        $supplier->remarks = $request->remarks;
        $supplier->address = $request->address;
        $supplier->save();
        $request->session()->flash('success_message', 'Supplier Update successful');
        return redirect()->route('supplier.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Supplier  $supplier
     * @return \Illuminate\Http\Response
     */
    public function destroy(Supplier $supplier)
    {
        //
    }
}
