@extends('layout.app')

@section('content')
    <h4>Onu's information</h4>

    <div class="container-fluid bg-white my-3 py-2 shadow-sm">
        <div class="d-flex justify-content-between mb-2">
            <p id="totalDevices">Total: Loading...</p>
            @if (Auth::user()->id == 1)
                <a href="{{ route('oltOnuInformationTruncate') }}" class="btn btn-danger float-right">Truncate</a>
            @endif
        </div>
        <table id="devicesTable" class="display">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>OLT Address</th>
                    <th>OLT Name</th>
                    <th>Username</th>
                    <th>ONU ID</th>
                    <th>MAC</th>
                    <th>VLAN</th>
                    <th>Interface</th>
                    <th>Laser(Power)</th>
                    <th>Updated At</th>
                </tr>
            </thead>
            <tbody>
                <!-- Data will be loaded via AJAX -->
            </tbody>
        </table>
    </div>
@endsection

@section('ajax')
    <script>
        $(document).ready(function() {
            var table = $('#devicesTable').DataTable({
                "processing": true,
                "serverSide": true,
                "ajax": {
                    "url": "{{ route('onu-information-data') }}",
                    "type": "GET",
                    "error": function(xhr, error, code) {
                        console.log('Error:', error, code);
                        alert('Error loading data. Please refresh the page.');
                    }
                },
                "columns": [
                    { "data": "id", "name": "id", "width": "5%" },
                    { "data": "oltaddress", "name": "oltaddress", "width": "10%" },
                    { "data": "oltName", "name": "oltName", "width": "10%" },
                    { "data": "username", "name": "username", "width": "10%" },
                    { "data": "onuid", "name": "onuid", "width": "8%" },
                    { "data": "mac", "name": "mac", "width": "12%" },
                    { "data": "Vlan", "name": "Vlan", "width": "8%" },
                    { "data": "interface", "name": "interface", "width": "12%" },
                    { "data": "laser", "name": "laser", "width": "10%" },
                    { "data": "updated_at", "name": "updated_at", "width": "15%" }
                ],
                "order": [
                    [9, "desc"]
                ],
                "pageLength": 100,
                "pagingType": "full_numbers",
                "lengthMenu": [[25, 50, 100, -1], [25, 50, 100, "All"]],
                "searchDelay": 500,
                "language": {
                    "processing": "Loading data...",
                    "search": "Search all columns:",
                    "lengthMenu": "Show _MENU_ entries per page",
                    "info": "Showing _START_ to _END_ of _TOTAL_ entries",
                    "infoEmpty": "No entries found",
                    "infoFiltered": "(filtered from _MAX_ total entries)",
                    "zeroRecords": "No matching records found"
                },
                "drawCallback": function(settings) {
                    var api = this.api();
                    var recordsTotal = api.page.info().recordsTotal;
                    var recordsFiltered = api.page.info().recordsFiltered;

                    if (recordsFiltered < recordsTotal) {
                        $('#totalDevices').text('Total: ' + recordsFiltered + ' (filtered from ' + recordsTotal + ')');
                    } else {
                        $('#totalDevices').text('Total: ' + recordsTotal);
                    }
                }
            });
        });
    </script>
@endsection
