import { useState } from 'react';
import { Button, Form } from 'react-bootstrap';
import { useDispatch } from 'react-redux';
import { addNewTjBox } from '../../../../store/asyncMethods/tjBoxMethod';
import useEditablePolyline from '../../../../hooks/useEditablePolyline';

const TjBoxCreate = ({ handleClose }) => {
  const dispatch = useDispatch();
  const [tjBoxForm, setTjBoxForm] = useState({
    name: '',
    remarks: '',
  });
  const { coordinates, reset } = useEditablePolyline();

  const onChangeHandler = (event) => {
    setTjBoxForm({ ...tjBoxForm, [event.target.name]: event.target.value });
  };

  const onSubmitHandler = (event) => {
    event.preventDefault();``

    const tjBoxData = {
      name: tjBoxForm.name,
      remarks: tjBoxForm.remarks,
      coordinates: coordinates[0],
    };
    dispatch(
      addNewTjBox(tjBoxData, () => {
        reset();
        handleClose();
      })
    );
  };

  return (
    <Form className='mt-2' onSubmit={onSubmitHandler}>
      <Form.Group>
        <Form.Control type='text' value='Nothing on Parent' disabled />
      </Form.Group>

      <Form.Group className='mt-2'>
        <Form.Control
          type='text'
          placeholder='TJ Box Name'
          onChange={onChangeHandler}
          name='name'
        />
      </Form.Group>
      <Form.Group className='mt-2'>
        <Form.Control
          as='textarea'
          placeholder='Remarks'
          rows={3}
          onChange={onChangeHandler}
          name='remarks'
        />
      </Form.Group>

      <Form.Group className='mt-2 text-right'>
        <Button variant='secondary' onClick={handleClose}>
          Close
        </Button>
        <Button variant='primary' type='submit' className='ms-1'>
          Submit
        </Button>{' '}
      </Form.Group>
    </Form>
  );
};

export default TjBoxCreate;
