import { useEffect, useState } from 'react';
import { Col, Form } from 'react-bootstrap';
import axiosInstance from '../../../../../util/axiosInstance';
import { getColor } from '../../../../../util/colorModule';

export function TJBoxConnectDownStream({
    down_stream,
    tjBoxCableConnectInfo,
    tjBoxConnectDispatch,
}) {
    const [cableInfo, setCableInfo] = useState(null);

    useEffect(() => {
        if (tjBoxCableConnectInfo.down_stream) {
            const fetchCableInfo = async () => {
                try {
                    const { data } = await axiosInstance.get(
                        `/cables/${tjBoxCableConnectInfo.down_stream}/detail`
                    );
                    setCableInfo(data);
                } catch (error) {
                    console.log(error);
                }
            };
            fetchCableInfo();
        }
    }, [setCableInfo, tjBoxCableConnectInfo.down_stream]);

    const handleDownStreamChange = (e) => {
        const down_stream_id = parseInt(e.target.value);
        tjBoxConnectDispatch({ type: 'SET_DOWN_STREAM', down_stream_id });
    };

    const handleDownStreamTubeChange = (e) => {
        const down_stream_tube_id = parseInt(e.target.value);
        tjBoxConnectDispatch({
            type: 'SET_DOWN_STREAM_TUBE',
            down_stream_tube_id,
        });
    };

    const handleDownStreamFiberChange = (e) => {
        const down_stream_fiber_id = parseInt(e.target.value);
        tjBoxConnectDispatch({
            type: 'SET_DOWN_STREAM_FIBER',
            down_stream_fiber_id,
        });
    };

    return (
        <Col lg={6}>
            <Form.Group>
                <Form.Label>Down Stream Cable</Form.Label>
                <Form.Select onChange={handleDownStreamChange}>
                    <option>Select Down-Stream Cable</option>
                    {down_stream.map((cable) => {
                        return (
                            <option value={cable.id} key={cable.id}>
                                {cable.id}. {cable.name}
                            </option>
                        );
                    })}
                </Form.Select>
            </Form.Group>
            {cableInfo && (
                <Form.Group>
                    <Form.Label>Down Stream Tube</Form.Label>
                    <Form.Select onChange={handleDownStreamTubeChange}>
                        <option>Select Down-Stream Tube</option>
                        {cableInfo.tubes.map((tube) => {
                            return (
                                <option value={tube.id} key={tube.id}>
                                    {tube.tube_number}.{' '}
                                    {getColor(tube.tube_number)}
                                </option>
                            );
                        })}
                    </Form.Select>
                </Form.Group>
            )}

            {tjBoxCableConnectInfo.down_stream_tube && (
                <Form.Group>
                    <Form.Label>Down Stream Fiber</Form.Label>
                    <Form.Select onChange={handleDownStreamFiberChange}>
                        <option>Select Down-Stream Fiber</option>
                        {cableInfo?.tubes
                            .find(
                                (tube) =>
                                    tube.id ===
                                    tjBoxCableConnectInfo.down_stream_tube
                            )
                            ?.fibers.map((fiber) => {
                                return (
                                    <option value={fiber.id} key={fiber.id}>
                                        {fiber.fiber_number}.{' '}
                                        {getColor(fiber.fiber_number)}{' '}
                                        {fiber.parent_fiber ||
                                        fiber.parent_component
                                            ? ' - Used'
                                            : ' - Available'}
                                    </option>
                                );
                            })}
                    </Form.Select>
                </Form.Group>
            )}
        </Col>
    );
}
