<!DOCTYPE HTML>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>Print</title>
    <style type="text/css">
        table {
            page-break-inside: auto
        }

        tr {
            page-break-inside: avoid;
            page-break-after: auto
        }

        thead {
            display: table-header-group
        }

        tfoot {
            display: table-footer-group
        }
    </style>
</head>

<body>
    <style>
        @media print {

            thead th {
                font-size: 15px !important;
                border: 1px solid #010a02;
                /* background-color: #4CAF50; */
            }

            table,
            tr,
            th,
            td {
                font-size: 9px !important;
                padding: 2px !important;
                border: 1px solid #010a02;
                border-collapse: collapse;
            }

            .searchClient,
            button {
                visibility: hidden;
            }

            table {
                /* width: 107%; */
            }

        }

        .container {
            width: 900px;
            margin: 0 auto;
            padding: 2px;
        }

        .table {
            border-collapse: collapse;
            width: 80%;
            border: 1px solid #4CAF50;
        }

        th,
        td {
            border: 1px solid #bbb;
            padding: 5px;
            text-align: left;
        }

        tr:hover {
            background-color: #e5e5e5
        }
    </style>

    <div class="flex flex-col mt-5">
        <div class=" bg-white p-6 rounded-lg">

            <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
                <div class="py-2 align-middle inline-block min-w-full sm:px-6 lg:px-8">
                    <div class="shadow overflow-hidden border-b border-gray-200 sm:rounded-lg">

                        <div class="p-2 mb-5">
                            <button type="button" onclick="window.print()">Print
                                <i class="fa fa-print"></i>
                            </button>
                        </div>

                        <div class="table-responsive">
                            <table id="dataTable" class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th>ID</th>
                                        <th>User name</th>
                                        <th>Name</th>
                                        <th>Contact</th>
                                        <th>Address</th>
                                        <th>Zone/POP</th>
                                        <th>Package</th>
                                        <th>Exp. Date</th>
                                        <th>OTC</th>
                                        <th>Previous Due</th>
                                        <th>Bill Amount</th>
                                        <th>Total Dues</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @foreach ($list as $r)
                                        <tr>
                                            <td>
                                                @php(printf('CID%04d', $r->id))
                                            </td>
                                            <td>
                                                {{ $r->userid }}
                                            </td>
                                            <td class="whitespace-nowrap">
                                                {{ $r->clientsinfo->clients_name ?? '' }}
                                            </td>
                                            <td>
                                                {{ $r->clientsinfo->contact_no ?? '' }}
                                            </td>
                                            <td>
                                                Flat No: {{ $r->clientsinfo->flat_no ?? '' }} ,
                                                Building Name: {{ $r->clientsinfo->building_name ?? '' }} ,
                                                Road No: {{ $r->clientsinfo->road_no ?? '' }} ,
                                                Block/Sector: {{ $r->clientsinfo->block_sector ?? '' }} ,
                                                Area : {{ $r->clientsinfo->area ?? '' }}
                                            </td>
                                            <td style="width:100px;">
                                                {{ $r->pop->popname }}
                                            </td>
                                            <td style="width:100px;">
                                                {{ $r->packages->package_name }}
                                            </td>
                                            <td class="whitespace-nowrap" style="width:100px">
                                                {{ date('d-M-Y', strtotime($r->expire_date)) }}
                                            </td>
                                            <td>{{ $r->clientsinfo->otc_due }}</td>
                                            <td>
                                                @if ($r->customerAccount->dueAmount - $r->packages->package_rate > 0)
                                                    {{ $r->customerAccount->dueAmount - $r->packages->package_rate }}
                                                @else
                                                    {{ 0 }}
                                                @endif
                                            </td>
                                            <td>
                                                {{ $r->packages->package_rate }}
                                            </td>
                                            <td>
                                                {{ $r->customerAccount->dueAmount }}
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- @endsection --}}
    @section('ajax')
        <script type="text/javascript">
            $(document).ready(function() {

                    $('.singlePayment').on('click', function(e) {
                            e.preventDefault();
                            var id = $(this).data('id');

                            if (confirm('Are you Confirm! You want to pay the bill!')) {
                                $('body').append('<div id="loading">Processing.....</div>');

                                $.ajax({

                                        type: 'POST',
                                        url: '{{ route('singlePayment') }}',
                                        data: $(this.form).serialize(),
                                        dataType: 'json',
                                        success: function(data) {
                                            if (data.status == 'error') {
                                                $('#loading').remove();
                                                $('body').append(data.message);
                                            }

                                            if (data.status == 'success') {
                                                $('#loading').remove();
                                                $('body').append(data.message);
                                                // console.log(data.message);

                                                $('.btn' + id).remove();
                                            }
                                        }
                                    }

                                );

                            }

                        }

                    );


                }

            );
        </script>

        {{-- @endsection --}}

    </body>

    </html>
