@can('dashboard-billing-info')
    <section class="card">
        <div class="card-header">
            <h1 class="card-title float-none ">Report
                Manager wise (only own)
                of
                Monthly Generated Bill Collection
                {{ date('M') }}
                {{ date('Y') }}</h1>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover table-responsive-lg ">
                    <thead>
                        <tr>
                            <th scope="col" class="h6">Manager</th>
                            <th scope="col" class="h6">Bill Client</th>
                            <th scope="col" class="h6 text-left">Bill Amount</th>
                            <th scope="col" class="h6">Received Client</th>
                            <th scope="col" class="h6 text-right">Received Amount</th>
                            <th scope="col" class="h6 text-right">Discount Amount</th>
                            <th scope="col" class="h6">Collection(%)</th>
                            <th scope="col" class="h6">Dues Clients</th>
                            <th scope="col" class="h6 text-right">Dues Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $dueClients = 0;
                            $dueAmounts = 0;
                            $clientscount = 0;
                            $totalBill = 0;
                            // $totalAdjustment = 0;
                            $totalPaid = 0;
                            $totalDiscount = 0;
                        @endphp

                        {{-- {{ dd($resellers)}} --}}

                        @foreach ($resellers->where('reseller_type', 'own') as $reseller)
                            @php

                                $rTotalClient = 0;
                                $rTotalBill = 0;
                                $rTotalPaid = 0;
                                $rTotalDueAmount = 0;
                                $rTotaldueClient = 0;
                                $rTotalDiscount = 0;

                            @endphp

                            @foreach ($popWiseBillReport->where('reseller_id', $reseller->id) as $item)
                                @php
                                    $totalBill += $item->total_bill;
                                    $clientscount += $item->total_row;
                                    $dueClients += $item->not_paid;
                                    $dueAmounts += $item->total_bill - $item->total_paid;
                                    $totalPaid += $item->total_paid;
                                    $totalDiscount += $item->total_discount;

                                    $rTotalClient += $item->total_row;
                                    $rTotalBill += $item->total_bill;
                                    $rTotalPaid += $item->total_paid;
                                    $rTotalDueAmount += $item->total_bill - $item->total_paid;
                                    $rTotaldueClient += $item->not_paid;
                                    $rTotalDiscount += $item->total_discount;
                                @endphp
                            @endforeach

                            <tr class="text-center">
                                <td class="manager-bg" style="text-align: start !important;">{{ $reseller->name }}</td>
                                <td>{{ $rTotalClient }}</td>
                                <td class="table-data">
                                    {{ $rTotalBill }}
                                </td>
                                <td>{{ $rTotalClient - $rTotaldueClient }}</td>
                                <td class="table-data">{{ $rTotalPaid - $rTotalDiscount }}</td>
                                <td>{{ $rTotalDiscount }}</td>
                                <td class="table-data">
                                    @if ($rTotalPaid != 0 && $rTotalBill != 0)
                                        {{ round(($rTotalPaid * 100) / $rTotalBill, 2) }}%
                                    @else
                                        0%
                                    @endif
                                </td>
                                <td class="text-center">{{ $rTotaldueClient ?? 0 }}</td>
                                <td class="text-center table-data">{{ $rTotalBill - $rTotalPaid }}</td>
                            </tr>
                        @endforeach


                        <tr style="background: #78716C; color:#FFFFFF;">
                            <td class="h6">Total</td>
                            <td class="h6 text-center">{{ $clientscount }}</td>
                            <td class="h6 text-center">{{ $totalBill }}</td>
                            <td class="h6 text-center">{{ $clientscount - $dueClients }}</td>
                            <td class="h6 text-center">{{ round($totalPaid) - round($totalDiscount) }}</td>
                            <td class="h6 text-center">{{ round($totalDiscount) }}</td>
                            <td class="h6">
                                <span class="text-center">
                                    @if ($totalBill != 0)
                                        {{ number_format(($totalPaid * 100) / $totalBill, 2) }} %
                                    @else
                                        0%
                                    @endif
                                </span>

                            </td>
                            <td class="h6 text-center">
                                {{ $dueClients }}
                            </td>

                            <td class="h6 text-center">
                                <span class="text-default">
                                    {{ round($dueAmounts) }}
                                </span>
                            </td>

                        </tr>
                    </tbody>
                </table>
            </div>
        </div>


    </section>


@endcan


<style>
    .card-title {
        font-size: 32px !important;
        text-align: center !important;
        letter-spacing: 0.10rem;
        font-weight: 500;
    }

    .manager-bg {
        background-color: rgb(221 214 254 / 0.05);
        --tw-text-opacity: 1;
        color: rgb(3 7 18 / var(--tw-text-opacity));
    }

    .table-data {
        background-color: rgb(255 241 242 / 0.5);
        --tw-text-opacity: 1;
        color: rgb(15 23 42 / var(--tw-text-opacity));
    }
</style>
