@extends('layout.app')


@section('content')
    <form action="{{ route('item.update', $list->id) }}" method="POST">
        @method('PUT')
        @csrf
        <div class=" card">
            <div class="card-body">
                <div class="row">
                    <div class="form-group col-md-4">
                        <label for="nas_id" class="">
                            Category*
                        </label>

                        <select name="category_id" id="category_id" class="form-control select2" required>
                            <option value="">Select Category</option>
                            @foreach ($categories as $category)
                                <option class="p-5" {{ $category->id == $list->category_id ? 'selected' : '' }}
                                    value="{{ $category->id }}">{{ $category->name }} (
                                    {{ $category->bn_name }})
                                </option>
                            @endforeach
                        </select>
                        @error('category_id')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="name" class="">
                            Name*
                        </label>

                        <input type="text" name="name" id="name" value="{{ $list->name }}" class="form-control" required
                            placeholder=" Name" autocomplete="off">
                        @error('name')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>


                    <div class="form-group col-md-4">

                        <label for="bn_name" class="">
                            Name (Bangla)
                        </label>

                        <input type="text" name="bn_name" id="bn_name" value="{{ $list->bn_name }}"
                            class="form-control" placeholder=" bn_name" autocomplete="off">
                        @error('bn_name')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">

                        <label for="short_name" class="">
                            Short Name
                        </label>
                        <input type="text" name="short_name" id="short_name" value="{{ $list->short_name }}"
                            class="form-control" placeholder=" short_name" autocomplete="off">
                        @error('short_name')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>


                    <div class="form-group col-md-4">

                        <label for="nas_id" class="">
                            Unit*
                        </label>

                        <select name="unit_id" id="unit_id" class="form-control select2" required>
                            <option value="">Select Unit</option>
                            @foreach ($units as $unit)
                                <option class="p-5" {{ $unit->id == $list->unit_id ? 'selected' : '' }}
                                    value="{{ $unit->id }}">{{ $unit->name }}</option>
                            @endforeach
                        </select>
                        @error('unit_id')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="nas_id">
                            Serial No
                        </label>

                        <select name="serial_number" id="serial_number" class="form-control select2">
                            <option value="enable" {{ $list->serial_number == 'enable' ? 'selected' : '' }}>Enable</option>
                            <option value="disable" {{ $list->serial_number == 'disable' ? 'selected' : '' }}>Disable
                            </option>

                        </select>

                    </div>
                    <div class="form-group col-md-4">
                        <label for="short_name">
                            Alert quantity*
                        </label>

                        <input type="number" name="alert_quantity" id="alert_quantity"
                            value="{{ $list->alert_quantity ?? 0 }}" class="form-control" required
                            placeholder="alert_quantity" autocomplete="off">
                        @error('alert_quantity')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>


                    <div class="form-group col-md-12">

                        <label for="remarks" class="">
                            Remarks
                        </label>

                        <input type="text" name="remarks" id="remarks" value="{{ $list->remarks }}"
                            class="form-control" placeholder=" remarks" autocomplete="off">
                        @error('remarks')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>

                <div class="form-group">
                    <div class="row float-right">
                        <a href="{{ url()->previous() }}">
                            <button class="btn btn-primary">Back</button>
                        </a>
                        @can('inventory_update')
                            <button type="submit" class="ml-2 btn btn-success">
                                Update
                            </button>
                        @endcan
                    </div>
                </div>
                @can('change_item_crm_status')

                    <div class="form-group col-md-4">
                        <label for="nas_id">
                            Show In CRM
                        </label>

                        <select name="show_crm" id="show_crm" class="form-control ">
                            <option value="Yes" {{$list->show_crm == "Yes" ? 'selected' : ''}} >Yes</option>
                            <option value="No" {{$list->show_crm == "No" ? 'selected' : ''}}>No</option>

                        </select>

                    </div>
                @endcan
            </div>
        </div>
    </form>

    <div class="p-5"></div>
@endsection
