@extends('layout.app')

@push('styles')
@endpush

@section('content')
    <div class="card card-body">
        <div class="container">
            <h2>Edit Thana</h2>
            <form action="{{ route('thanaUpdate') }}" method="POST">
                @csrf
                @method('POST')

                <input type="hidden" name="id" value="{{ $thana->id }}">
                <div class="form-group">
                    <label for="upazila_id">Upazila</label>
                    <select name="upazila_id" id="upazila_id" class="form-control select2">
                        <option value="">Select Upazila</option>
                        @foreach ($upazilas as $item)
                            <option value="{{ $item->id }}" {{ $thana->upazila_id == $item->id ? 'selected' : '' }}>
                                {{ $item->name }} -- {{ $item->bn_name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="name">Name(English)</label>
                    <input type="text" name="name" class="form-control" value="{{ $thana->name }}"
                        placeholder="name">
                </div>

                <div class="form-group">
                    <label for="bn_name">Name(Bengali)</label>
                    <input type="text" name="bn_name" class="form-control" value="{{ $thana->bn_name }}"
                        placeholder="name bengali">
                </div>

                <button type="submit" class="btn btn-primary">Update Location</button>
            </form>
        </div>
    </div>
@endsection


@section('ajax')
    <script></script>
@endsection
