<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithMapping;

class ClientUploadDownloadExport implements FromCollection, WithHeadings, ShouldAutoSize, WithMapping
{
    protected $data;

    function __construct($data)
    {
        $this->data = $data;
    }

    public function headings(): array
    {
        return [
            'User ID',
            'Name',
            'Contact',
            'Status',
            'Package',
            'POP',
            'Reseller',
            'Expire Date',
            'Down Load (GB)',
            'Up Load (GB)',
            'Total (GB)',
            'Extra Limit'
        ];
    }

    public function map($client): array
    {
        $total = (($client->down_bandwidth ?? 0) + ($client->up_bandwidth ?? 0))/1024;

        // Format bandwidth values
        $downMB = ($client->down_bandwidth ?? 0) / 1024;
        $upMB = ($client->up_bandwidth ?? 0) / 1024;

        return [
            $client->userid ?? '',
            $client->clientsinfo->clients_name ?? '',
            $client->clientsinfo->contact_no ?? '',
            $client->clients_status ?? '',
            $client->packages->package_name ?? '',
            $client->pop->popname ?? '',
            $client->pop->reseller->name ?? '',
            $client->expire_date ?? '',
            number_format($downMB, 2),
            number_format($upMB, 2),
            number_format($total, 2),
            $client->bandwidth_limit ?? '',
        ];
    }

    public function collection()
    {
        return $this->data;
    }
}
