@extends('layout.app')

@section('content')

    <div class="card card-default">
        <div class="card-body">

            <input type="hidden" id="item_id" name="item_id" value="{{$item_id}}">
            <input type="hidden" id="purchase_id" name="purchase_id" value="{{$purchase_id}}">

            <div  id="tableId">

                <table class="table" id="result">
                    <thead>
                        <th>#</th>
                        <th>Serial No</th>
                        <th>Status</th>
                        <th>Action</th>
                    </thead>
                    <tbody >
                        @foreach ($serialNumbers as $index=>$serialNumber)
                        <tr id="{{$index }}">
                            <td class="row_id">{{ $index }}</td>
                            <td class="serial_id" style="display: none">{{ $serialNumber->id }}</td>
                            <td class="serial_no">{{ $serialNumber->serial_no }}</td>
                            <td>{{$serialNumber->status}}</td>
                            <td>
                                <div class="row">
                                    <a href="#">
                                        <button class="btn btn-success showEdit">Edit</button>
                                    </a>
                                    <a href="#">
                                        <button class="btn '+c+' btn-info ml-2 delete">Delete</button>
                                    </a>
                                </div>
                            </td>
                        </tr>

                        @endforeach

                    </tbody>
                </table>

            </div>
            <div class="modal fade" id="changeSerialNoModal">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"
                                aria-label="Close"><span aria-hidden="true">&times;</span></button>

                        </div>
                        <div class="modal-body">

                            <div class="form-group">
                                <label for="amount">Previous Serial Number</label>
                                <input type="text" class="form-control"  id="pre_serial_no" />
                                <input type="hidden" class="form-control"  id="pre_serial_id"  />
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" id="change_serial_no" class="btn btn-primary">Save</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="p-5">
                {{ $serialNumbers->links() }}
            </div>
        </div>


    </div>


@endsection


@push('js')
<script>
     $(document).ready(function() {
        var rowNumber=-1;
        $('.showEdit').on('click',function(){
            // console.log('comes');
            $('#changeSerialNoModal').modal('show');
            previousSerialNumber = $(this).closest('tr').find(".serial_no").html();
            pre_serial_id = $(this).closest('tr').find(".serial_id").html();
            rowNumber = $(this).closest('tr').find(".row_id").html();
            // console.log(rowNumber);
            $('#pre_serial_no').val(previousSerialNumber);
            $('#pre_serial_id').val(pre_serial_id);



        });

        $('.delete').on('click', function(){

            var product_id = $('#item_id').val();
            var purchase_id = $('#purchase_id').val();
            var pre_serial_id = $(this).closest('tr').find(".serial_id").html();
            rowNumber = $(this).closest('tr').find(".row_id").html();

            $.ajax({
                url: '{{ route('serial-no-delete') }}',
                type: 'post',
                data: {id: pre_serial_id},
                success: function(data){

                    if(data==1){
                        $('#'+rowNumber+'').hide();
                        toastr.success("Serial No Delete Successfull");
                    }else{
                        toastr.error("Serial Number Allready Used");
                    }
                }
            });
        });

        $('#change_serial_no').on('click',function(){

            new_serial=$('#pre_serial_no').val();
            item_id=$('#item_id').val();
            id=$('#pre_serial_id').val();

            if(new_serial != null){

                $.ajax({
                    url: '{{ route('edit-serial') }}',
                    type: 'post',
                    data: { data: new_serial, productId: item_id, id: id },
                    success: function(data) {
                        console.log(data);
                        if (data.result == 1) {

                            toastr.success("Serial No Update Successfull");
                            $('#result #'+rowNumber+' .serial_no').html(data.value);
                            $('#changeSerialNoModal').modal('toggle');

                        } else if (data.result == 2) {
                            toastr.error("This Serial No Allready Add For This Item");
                            $('#changeSerialNoModal').modal('toggle');
                        } else {
                            toastr.error("Previous Serial Number Allready Used");
                            $('#changeSerialNoModal').modal('toggle');
                        }
                    }
                });
            }


        });
     })
</script>

@endpush
