import { BsFillHddNetworkFill } from 'react-icons/bs';

export const ParentComponent = ({ connected_component }) => {
    if (connected_component.type === 'port') {
        return (
            <span>
                <BsFillHddNetworkFill /> {connected_component.device.name} (
                {connected_component.port_number}:{connected_component.label})
            </span>
        );
    } else if (connected_component.type === 'splitter_out') {
        return `${connected_component.splitter.name} (1:${connected_component.splitter.split_ratio})`;
    }
    return 'None';
};
