@extends('layout.app')


@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title" style="color:#115548;">Sale Invoice List</h3>
            <div class="card-tools">
                <a href="{{ route('bw-sale.create') }}"><button class="btn btn-sm btn-primary"><i class="fa fa-plus-circle"
                            aria-hidden="true"></i> &nbsp; Invoice</button></a>
            </div>
        </div>

        <div class="card-body">

            <div class="table-responsive">
                <table id="dataTable" class="display table table-bordered table-striped">
                    <thead class="bg-gray-50">
                        <tr>
                            <th>SL</th>
                            <th>Invoice No</th>
                            <th>Company</th>
                            <th>B Date</th>
                            <th>Total</th>
                            <th>Discount</th>
                            <th>Paid</th>
                            <th>Due</th>
                            <th>Bank Account</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @php
                            $total = 0;
                            $discount = 0;
                            $paid = 0;
                            $due = 0;
                        @endphp
                        @foreach ($list as $row)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $row->invoice_no }}</td>
                                <td>{{ $row->bandwidthSaleCustomer->customer_name ?? '' }}</td>
                                <td>{{ $row->billing_date }}</td>
                                <td style="text-align: right">{{ $row->total }}</td>
                                <td style="text-align: right">{{ $row->discount }}</td>
                                <td style="text-align: right">{{ $row->paid }}</td>
                                <td style="text-align: right">
                                    @php
                                        $d_amount = $row->total - ($row->discount + $row->paid);
                                    @endphp
                                    {{ number_format($d_amount, 2) }}
                                </td>
                                <td>
                                    @if($row->bankAccount)
                                        <span class="badge badge-info">
                                            {{ $row->bankAccount->account_name }} - {{ $row->bankAccount->bank_name }}
                                        </span>
                                    @else
                                        <span class="badge badge-secondary">Cash</span>
                                    @endif
                                </td>
                                <td style="">
                                    <div class="row">
                                        <div>
                                            <a href="{{ route('bw-sale.edit', $row->id) }}" class="btn btn-sm btn-primary ml-2 mr-2">Edit</a>
                                        </div>
                                        <div>
                                            <a href="{{ route('bandwidthSaleInvoice', $row->id) }}" class="btn btn-sm btn-success">Download PDF</a>
                                        </div>
                                    </div>
                                </td>
                                @php
                                    $total += $row->total;
                                    $discount += $row->discount;
                                    $paid += $row->paid;
                                    $due += $row->total - ($row->discount + $row->paid);
                                @endphp
                            </tr>
                        @endforeach
                        <tr>
                            <td colspan="4" style="text-align: right"><b>Total</b></td>
                            <td style="text-align: right"><b>{{ number_format($total, 2) }}</b></td>
                            <td style="text-align: right"><b>{{ number_format($discount, 2) }}</b></td>
                            <td style="text-align: right"><b>{{ number_format($paid, 2) }}</b></td>
                            <td style="text-align: right"><b>{{ number_format($due, 2) }}</b></td>
                            <td></td>
                            <td></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
