@extends('layout.app')
@section('content')
<div class="row">
    <div class="col-sm-6">

        <div class="card">
            <div class="card-body">


                <form action="{{ route('subRsellerRechargeUpdate') }}" method="POST" class="form">
                    @csrf


                    <p class="p-2">Pop Name: {{ $pop->popname }}</p>
                    <p class="p-2">Current Balance: {{ $pop->balance[0]['amount'] ?? 0 }}</p>

                    <div class="form-group">
                      <label for="amount">Amount</label>

                      <input type="number" name="amount" placeholder="0" class="form-control" required>
                      @error('amount')<div class="text-red-500 mt-2 text-sm">{{$message}}</div>@enderror

                  </div>

                  <div class="form-group">

                      <label for="remark">Remark</label>
                      <input type="text" name="remark" class="form-control" required>
                      @error('remark')<div class="text-red-500 mt-2 text-sm">{{$message}}</div>@enderror

                  </div>

                    <div class="form-group">
                        <input type="hidden" value="{{ $pop->id }}" name="type_id">
                        <input type="hidden" value="pop" name="type">
                        <a href="{{route('pop.index')}}" class="btn btn-default float-left"><i
                                class="fa fa-arrow-left"></i> Back</a>
                        <button type="submit" class="btn btn-primary float-right"><i class="spinner fa fa-spin fa-spinner"></i> Recharge</button>
                    </div>

                </form>
            </div>
        </div>
    </div>
    <div class="col-sm-6">
        <div class="card">
            <div class="card-body">
                <p class="p-2">POP Recharge History </p>

                <div class="form-group">
                    <div class="table-responsive">
                    <table class="table">
                        <thead class="bg-blue-50">
                            <tr>
                                
                                        <th scope="
                                    col"
                                    class="">
                                            Date
                                        </th>

                                        <th scope="
                                    col"
                                    class="">
                                            Amount
                                        </th>

                                        <th scope="
                                    col"
                                    class="">
                                            After Recharge Balance
                                        </th>

                                        <th scope="
                                    col"
                                    class="">
                                            Remarks
                                        </th>
                                        <th scope="
                                    col"
                                    class="">
                                            Recharge By
                                        </th>
                                        <th scope="
                                    col"
                                    class="">

                                        </th>
                            </tr>
                        </thead>
                        <tbody class="
                                    bg-white divide-y divide-gray-200">

                                    @foreach ($popList as $r)

                            <tr>
                               
                                <td class="px-6 py-4 whitespace-nowrap">
                                    {{ date('d-M-Y h:i:sa', strtotime($r->created_at)) }}
                                </td>



                                <td class="px-6 py-4 whitespace-nowrap text-right">
                                    {{ $r->amount }}
                                </td>


                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-right">
                                    {{ $r->after_recharge_balance }}
                                </td>

                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $r->remarks }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $r->user->name ?? '' }}
                                </td>


                            </tr>

                            @endforeach
                            </tbody>
                    </table>
                    </div>





                </div>
            </div>
        </div>
    </div>

</div>




@endsection