@extends('layout.app')


@section('content')

    <div class="card">

        <div class="card-body">
            <form action="#" id="search" class="paymentHistory">
                <h4 class="p-2 border-l">{{ $page_title }}</h4>

                <div class="row">
                    <div class="col-md-2 col-sm-4">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                From Date
                            </label>
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input type="text" name="from_date" value="{{ $start->format('m/d/y') }}"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-4">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                To Date
                            </label>
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" name="to_date" value="{{ $end->format('m/d/y') }}"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-2 col-sm-4">
                        <div class="form-group">
                            <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Select
                                Manager</label>
                            <select name="reseller_id" id="reseller_id" class="select2 form-control">
                                <option value="">All Reseller</option>
                                @foreach ($reseller as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-2 col-sm-4">
                        <div class="form-group">
                            <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Select
                                Sub-Manager/Pop</label>
                            <select name="pop_id" id="pop" class="select2 form-control">
                                <option value="">All Pops/Sub-manager</option>
                            </select>
                        </div>
                    </div>
                    @if (auth()->user()->hasRole('Admin'))
                        <div class="col-md-2 col-sm-4">
                            <label>Select Area :</label>
                            <select name="area" id="area" class="form-control select2">
                                <option value="">Select Area</option>
                                @foreach ($areas as $area)
                                    <option value="{{ $area->area }}">{{ $area->area }}</option>
                                @endforeach
                            </select>
                        </div>
                    @endif
                    @if (request()->path() == 'admin/paymentReport' || request()->path() == 'admin/paymentReportSearch')

                    @unlessrole('Reseller')
                        <div class="col-md-2 col-sm-4">
                            <div class="form-group">
                                <label
                                    class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Collector</label>
                                @if (auth()->user()->hasrole('Admin'))
                                    <select name="collected_by[]" class="select2 form-control" multiple>
                                        <option value="">Select Employee</option>
                                        @foreach (employees() as $employee)
                                            @if ($employee->admin == null || $employee->admin->user_accounting_status == 'yes')
                                                <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                @else
                                    @if (auth()->user()->hasPermissionTo('change-collector'))
                                        <select name="collected_by[]" class="select2 form-control" multiple>
                                            <option value="">Select Employee</option>
                                            @forelse (employees() as $employee)
                                                @if ($employee->admin == null || $employee->admin->user_accounting_status == 'yes')
                                                    <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                                                @endif
                                            @empty
                                            @endforelse
                                        </select>
                                    @else
                                        <select name="collected_by[]" class="select2 form-control" multiple>
                                            {{-- id="readonlySelect"> --}}
                                            <option value="">Select Employee</option>
                                            @forelse (employees() as $employee)
                                                @if (
                                                    $employee->name == 'bkash' ||
                                                        $employee->name == 'Bkash-Online' ||
                                                        $employee->name == 'nagad' ||
                                                        $employee->name == 'Nagad-Online' ||
                                                        $employee->name == 'upay' ||
                                                        $employee->admin_user_id == auth()->user()->id)
                                                    <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                                                @endif
                                            @empty
                                            @endforelse
                                        </select>
                                    @endif
                                @endif
                            </div>
                        </div>

                        <div class="col-md-2 col-sm-4">
                            <div class="form-group">
                                <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Entry
                                    By</label>
                                @if (auth()->user()->hasrole('Admin'))
                                    <select name="user_by[]" class="select2 form-control" multiple>
                                        <option value="">Select User</option>
                                        @foreach ($users as $user)
                                            @if ($user->user_accounting_status == 'yes')
                                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                @else
                                    <select name="user_by[]" class="select2 form-control" multiple>
                                        {{-- id="readonlyUserSelect"> --}}
                                        <option value="">Select User</option>
                                        @forelse ($users as $user)
                                            @if ($user->user_accounting_status == 'yes')
                                                @if (
                                                    $user->name == 'bkash' ||
                                                        $user->name == 'Bkash-Online' ||
                                                        $user->name == 'nagad' ||
                                                        $user->name == 'Nagad-Online' ||
                                                        $user->name == 'upay' ||
                                                        $user->id == auth()->user()->id)
                                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                                @endif
                                            @endif
                                        @empty
                                        @endforelse
                                    </select>
                                @endif
                            </div>
                        </div>
                    @endunlessrole


                    <div class="col-md-2 col-sm-4">
                        <div class="form-group">
                            <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Type</label>
                            <select name="type" class="select2 form-control">
                                <option value="">Select</option>
                                <option value="paid_amount">Paid Amount</option>
                                <option value="discount_amount">Discount</option>
                                <option value="advance_adjust">Advance Adjust</option>
                                {{-- <option value="due">Due</option> --}}
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-4">
                        <div class="form-group" style="margin-top:40px">
                            <input type="checkbox" name="with_close_id">
                            <span>Payment Report With Close Id</span>
                        </div>
                    </div>

                    @endif

                    <div class="col-md-12">
                        <div class="form-group float-right">
                            <input type="hidden" name="otc" value="{{ $otc }}">
                            <button @click="search" class="btn btn-primary" type="submit" id="paymentSearch"><i
                                    class="fa fa-search"></i> Search</button>

                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>


                </div>
            </form>




            <div id="result">

            </div>



        </div>

    </div>


@endsection


@section('ajax')
    {{-- <script>
        $('.select2').select2();

        $('#readonlySelect').on('select2:opening select2:closing', function(e) {
            e.preventDefault();
        });
    </script> --}}
    <script>
        $(function() {

            $('#pop').select2();

            $('#reset').click(function() {
                $('#result').html('');
                $('.select2').val(null).trigger("change");
            });

            $('#reseller_id').on('change', function() {
                $("#loader").show();

                $.ajax({
                    type: 'get',
                    url: '{{ route('getPopForManager') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(data) {
                        $('#pop option').remove();
                        $('#pop').append(data);
                        $("#loader").hide();
                    }
                });


            });

            $('#payment_month').on('change', function() {
                var month = $('#payment_month').val();
                $('#description').val('Payment of month : ' + month + '. Bill Month : ' + month);
            });

            $('#paymentSearch').on('click', function(e) {
                $("#loader").show();
                e.preventDefault();
                $.ajax({
                    type: 'get',
                    url: '{{ route('paymentReportSearch') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $("#loader").hide();
                    }
                });

            });
        });
    </script>
@endsection
