<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Http\Controllers\ExpireCheckController;
use Illuminate\Support\Facades\Log;

class ExpireRecheck extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'expire:recheck-active';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Recheck if any user is not yet expire';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        Log::info("log -expire:recheck-active");

        ExpireCheckController::recheck();
    }
}
