<?php

namespace App\Http\Controllers\Map;

use App\Http\Controllers\Controller;
use App\Models\Client;
use App\Models\Clientsinfo;

class MapClientController extends Controller
{
    public static function getClientsOnlineInfo($clientsUsernames)
    {
        $onlineResultList = [];
        if (checkAPI()) {
            $online = mikrotikOnlineAndOfflineUsers();
            foreach ($clientsUsernames as $username) {
                if (array_key_exists($username, $online["onlineUsers"])) {
                    $onlineResultList[$username] = true;
                } else {
                    $onlineResultList[$username] = false;
                }
            }
        } else {
            $onlineList = Client::online($clientsUsernames);
            foreach ($clientsUsernames as $username) {
                if (!in_array($username, $onlineList)) {
                    $onlineResultList[$username] = 0;
                } else {
                    $onlineResultList[$username] = 1;
                }
            }
        }

        return $onlineResultList;
    }

    public static function getOnlyClientsStatus()
    {
        $clients = Clientsinfo::with("client:userid,id")->leftJoin("clients", "clients.id", "=", "clientsinfo.client_id")
            ->whereNull("clients.deleted_at")
            ->whereNotNull("map_box_id")
            ->whereNotNull("client_latitude")
            ->whereNotNull("client_longitude")
            ->get([
                "map_box_id",
                "client_id",
                "client_latitude",
                "client_longitude",
            ])->groupBy("map_box_id");

        foreach ($clients as $key => $client) {

            $usersId = Client::whereIn('id', $client->pluck('client_id'))->pluck('userid');
            $clientsOnlineInfo = self::getClientsOnlineInfo($usersId);

            $client->map(function ($client) use ($clientsOnlineInfo) {
                $client->status = $clientsOnlineInfo[$client->client->userid];
                return $client;
            });
        }

        $clientsWithoutBox = Clientsinfo::with("client:userid,id")->leftJoin("clients", "clients.id", "=", "clientsinfo.client_id")
            ->whereNull("clients.deleted_at")
            ->whereNull("map_box_id")
            ->whereNotNull("client_latitude")
            ->whereNotNull("client_longitude")
            ->get([
                "map_box_id",
                "client_id",
                "client_latitude",
                "client_longitude",
            ]);

        $clientsWithoutBoxUsernames = Client::whereIn('id', $clientsWithoutBox->pluck('client_id'))->pluck('userid');
        $clientsOnlineInfo = self::getClientsOnlineInfo($clientsWithoutBoxUsernames);
        foreach ($clientsWithoutBox as $client) {
            $client->status = $clientsOnlineInfo[$client->client->userid];
        }
        $clientsArray = $clients->toArray();
        $clientsArray['clientsWithoutBox'] = $clientsWithoutBox;

        return $clientsArray;
    }


    public function getClientDetail(string $clientId)
    {
        $loadFiled = [
            "id",
            "map_box_id",
            "client_id",
            "clients_name",
            "remarks",
            "flat_no",
            "building_name",
            "road_no",
            "area",
            "contact_no",
            "cable_type",
            "client_latitude",
            "client_longitude",
            "connected_component_type",
            "connected_component_id"
        ];
        $client = Clientsinfo::with("client:userid,password,clients_status,id", "connectedComponent.device", "connectedComponent.splitter")->where("client_id", $clientId)->get($loadFiled)->first();
        $client->status = self::getClientsOnlineInfo([$client->client->userid])[$client->client->userid];
        return $client;
    }
}
