@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="col-md-3 d-flex-justify-content-center">
                POP Name : {{ $pop->popname }}
            </div>

            <table class="table responsibe">
                <thead>
                    <th>Date</th>
                    <th>Edit By</th>
                    <th>Old Data</th>
                    <th>New Data</th>
                </thead>
                <tbody>
                    @foreach ($pop->popEditLog as $log)
                        @php
                            $old = json_decode($log->old_data);
                            $new = json_decode($log->new_data);

                            $change_old = [];
                            $change_new = [];
                            foreach ($old as $key => $value) {
                                if ($old->$key != $new->$key && $key != 'updated_at') {
                                    $change_old[$key] = $old->$key;
                                    $change_new[$key] = $new->$key;
                                }
                            }
                        @endphp
                        <tr>
                            <td>{{ $log->created_at }}</td>
                            <td>{{ $log->user->name }}</td>
                            <td>
                                @if ($change_old)
                                    @foreach ($change_old as $key => $value)
                                        <span class="badge badge-primary">{{ $key }}</span><span> :
                                            {{ $value }}</span><br>
                                    @endforeach
                                @endif
                            </td>
                            <td>
                                @if ($change_new)
                                    @foreach ($change_new as $key => $value)
                                        <span class="badge badge-warning">{{ $key }}</span><span> :
                                            {{ $value }}</span><br>
                                    @endforeach
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection

@section('ajax')
@endsection
