<?php ($permissions = userPermissions()); ?>
<div class="table-responsive" id="result" style="min-height:500px;">

    <input type="hidden" id="DaywiseRecharge" name="DaywiseRecharge"
        value="<?php echo e(checkSettings('recharge_expire_customer_today')); ?>">
    <?php if(request()->path() == 'admin/list/new-join' || request()->path() == 'admin/newClientSearchReport'): ?>
        <div class="float-right">Total : <?php echo e($list->total()); ?></div>
        <?php if($export == 'yes'): ?>
            <a class="noprint btn btn-primary m-1" href="<?php echo e(route('recentClientExport')); ?>"><i class="fa fa-print"></i>
                Download CSV</a>
        <?php endif; ?>
    <?php endif; ?>

    <?php if(request()->path() == 'admin/list/close-list'): ?>
        <a class="noprint btn btn-primary" href="<?php echo e(route('closeClientExport')); ?>"><i class="fa fa-print"></i>
            Export</a>
        <div class="float-right">Total Closed: <?php echo e($closeTotal ?? 0); ?></div>
    <?php endif; ?>
    <?php if(request()->path() == 'admin/close-search-list'): ?>
        <a class="noprint btn btn-primary mt-1 mb-1" href="<?php echo e(route('closeClientListExport')); ?>"><i
                class="fa fa-print"></i> Download CSV</a>
    <?php endif; ?>

    <?php if(request()->path() == 'admin/list/expired-Clients' || request()->path() == 'admin/expire-customer-search'): ?>
        <div class="mb-2">
            <?php if(request()->path() == 'admin/expire-customer-search'): ?>
                <a class="noprint btn btn-primary m-1" href="<?php echo e(route('expireClientExport')); ?>"><i
                        class="fa fa-print"></i>
                    Download CSV</a>
                
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <?php if(request()->path() == 'admin/free-cleint' || request()->path() == 'admin/freeClientSearch'): ?>
        <h5>Total Free Client: <?php echo e($list->count()); ?></h5>
    <?php endif; ?>
    <div class="scrollbar">
        <?php if(request()->path() == 'admin/pending-customer' || request()->path() == 'admin/pending-customer-search'): ?>
            <div>
                <?php if(request()->path() == 'admin/pending-customer-search'): ?>
                    <a class="noprint btn btn-primary m-2" href="<?php echo e(route('pendingCustomerExport')); ?>"><i class="fa fa-file-excel"></i>
                        Export Excel</a>
                <?php endif; ?>
                <?php if(checkSettings('local-user-first-approve') == 'enable'): ?>
                    <?php if(in_array('local-user-first-approve', $permissions)): ?>
                        <button class="btn btn-primary m-2" id="firstAllApprove"><i class="fa fa-check"></i>Final
                            Approve</button>
                    <?php elseif(in_array('new-customer-approve', $permissions)): ?>
                        <button class="btn btn-success float-right m-2" id="allApprove"><i class="fa fa-check"></i>
                            Approve</button>
                    <?php endif; ?>
                <?php else: ?>
                    <?php if(in_array('new-customer-approve', $permissions)): ?>
                        <button class="btn btn-success float-right m-2" id="allApprove"><i class="fa fa-check"></i>
                            Approve</button>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if(in_array('pending-customer-delete', $permissions)): ?>
                    <button class="btn btn-danger m-2 float-right" id="allDelete"><i class="fa fa-trash"></i>
                        Delete</button>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php if(checkSettings('all-client-dataTable') == 'enable' && request()->path() == 'admin/clients'): ?>
            <table id="dataTable" class="display" data-paging='false'>
                <style>
                    .dataTables_filter,
                    .dataTables_info {
                        display: none;
                    }
                </style>
            <?php elseif(request()->path() == 'admin/expire-customer-search' ||
                    request()->path() == 'admin/getResellerPopList' ||
                    request()->path() == 'admin/online-customer-search' ||
                    request()->path() == 'admin/list/new-join' ||
                    request()->path() == 'admin/newClientSearchReport' ||
                    request()->path() == 'admin/disable-customer-search' ||
                    request()->path() == 'admin/deactive-customer' ||
                    request()->path() == 'admin/active-customer' ||
                    request()->path() == 'admin/free-client' ||
                    request()->path() == 'admin/freeClientSearch'): ?>
                <table class="table table-bordered table-striped table-condensed table_dowanload product-table mt-3"
                    id="dataTable">
                <?php else: ?>
                    <table class="table table-bordered table-striped table-condensed table_dowanload product-table mt-3"
                        <?php if(isset($close)): ?> id="dataTable" <?php endif; ?>>
        <?php endif; ?>

        <thead>
            <tr style="background:#78716C !important; color:white;">
                <?php if(request()->path() == 'admin/clientSearchReport'): ?>
            <tr>
                <td colspan="15">
                    <p class="text-center"><?php echo e($status); ?></p>
                    <p class="text-center">
                        <?php echo $packages_count; ?>

                    </p>
                    <p class="text-center">
                        <?php echo $billing_count; ?>

                    </p>
                </td>
            </tr>
            <?php endif; ?>
            <?php if(request()->path() == 'admin/pending-customer' ||
                    request()->path() == 'admin/clientSearchReport' ||
                    request()->path() == 'admin/pending-customer-search'): ?>
                <th class="text-center">
                    <input type="checkbox" id="allSelect">
                </th>
            <?php endif; ?>
            <th>ID</th>
            <th style="width: 180px !important;">User name</th>
            <th>Status</th>
            <?php if(request()->path() == 'admin/clients'): ?>
                <th>
                    <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'expire_date', 'order' => request('sort') == 'expire_date' && request('order') == 'asc' ? 'desc' : 'asc'])); ?>"
                        style="color: white; text-decoration: none; cursor: pointer;">
                        Expire
                        <?php if(request('sort') == 'expire_date'): ?>
                            <?php if(request('order') == 'asc'): ?>
                                <i class="fa fa-sort-up"></i>
                            <?php else: ?>
                                <i class="fa fa-sort-down"></i>
                            <?php endif; ?>
                        <?php else: ?>
                            <i class="fa fa-sort"></i>
                        <?php endif; ?>
                    </a>
                </th>
            <?php else: ?>
                <th>Expire</th>
            <?php endif; ?>
            <th>Bill Info</th>
            <th>Package</th>
            <th>POP</th>
            <th>Name</th>
            <th>Contact</th>
            <th style="width:350px">User Info</th>
            <th>Date</th>
            <?php if(request()->path() == 'admin/list/close-list' || request()->path() == 'admin/close-search-list'): ?>
                <th>Close Date</th>
            <?php endif; ?>
            <th>Remarks</th>
            <?php if(request()->path() == 'admin/pending-customer'): ?>
                <th>Created By</th>
            <?php endif; ?>

            </tr>
        </thead>
        <?php if(auth()->user()->hasRole(['Sub Reseller'])): ?>
            <input type="hidden" id="checkSubReseller" value="Sub-Reseller">
        <?php endif; ?>
        <tbody>
            <?php ($catTotalLength = 0); ?>
            <?php ($totalOtc = 0); ?>
            <?php ($totalMrc = 0); ?>
            <?php ($apiCheck = checkAPI()); ?>




            <?php if(request()->path() == 'admin/list/disable-customer' ||
                    request()->path() == 'admin/list/expired-Clients' ||
                    request()->path() == 'admin/pending-customer'): ?>
                <h4>Total = <?php echo e($list->total()); ?></h4>
            <?php endif; ?>
            <?php if(request()->path() == 'admin/disable-customer-search' ||
                    request()->path() == 'admin/expire-customer-search' ||
                    request()->path() == 'admin/pending-customer-search' ||
                    request()->path() == 'admin/active-customer-search' ||
                    request()->path() == 'admin/close-search-list'): ?>
                <h4>Total = <?php echo e($list->count()); ?></h4>
            <?php endif; ?>


            <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                


                <tr <?php if($r->clients_status == 'deactive'): ?> class="deactive" <?php endif; ?>>
                    <?php if(request()->path() == 'admin/clientSearchReport'): ?>
                        <td class="text-center">
                            <?php if(in_array('customer-recharge', $permissions)): ?>
                                <?php if($r->pops->bill_generate != 'yes'): ?>
                                    <input type="checkbox" value="<?php echo e($r->id); ?>"
                                        class="checkbox checkboxR checkboxprice" id="row_id" name="ids[]">
                                    <?php if(auth()->user()->hasRole(['Reseller Admin', 'Admin', 'Accounts Executive', 'Reseller'])): ?>
                                        <input type="hidden" name="price[]" class="current_price"
                                            value="<?php echo e($r->packages->package_rate ?? 0); ?>">
                                    <?php elseif(auth()->user()->hasRole(['Sub Reseller'])): ?>
                                        <input type="hidden" name="price[]" class="current_price"
                                            value="<?php echo e($r->subpack->rate ?? 0); ?>">
                                    <?php endif; ?>
                                    <input type="hidden" name="ep_date" class="ep_date"
                                        value=<?php echo e(date('Y-M-d', strtotime($r->expire_date))); ?>>
                                    <input type="hidden" name="billing_cycle" class="billing_cycle"
                                        value=<?php echo e($r->billing_cycle); ?>>
                                    <input type="hidden" class="reseller_price"
                                        value="<?php echo e($r->packages->package_rate ?? 0); ?>">
                                    <input type="hidden" class="subreseller_price"
                                        value="<?php echo e($r->subpack->rate ?? 0); ?>">
                                <?php else: ?>
                                    <input type="checkbox" value="<?php echo e($r->id); ?>"
                                        class="checkbox checkboxR checkboxprice" id="row_id" name="ids[]">
                                <?php endif; ?>
                            <?php endif; ?>

                        </td>
                    <?php elseif(request()->path() == 'admin/pending-customer' || request()->path() == 'admin/pending-customer-search'): ?>
                        <td>
                            <input type="checkbox" class="checkbox new_class_for_client_id_of_pending" name="id[]"
                                value="<?php echo e($r->id); ?>">
                        </td>
                    <?php endif; ?>


                    <td class="text-center" data-order="<?php echo e($r->id); ?>">


                        <?php if($r->pop->bill_generate == 'yes'): ?>
                            <?php if(!globalPermission('payment-bill-by-bill')): ?>
                                <button data-package_rate="<?php echo e($r->packages->package_rate ?? 0); ?>"
                                    data-billing_type = "<?php echo e(getBillingType()); ?>" data-id="<?php echo e($r->id); ?>"
                                    data-userid="<?php echo e($r->userid); ?>"
                                    <?php if($r->customerAccount != null): ?> data-amount="<?php echo e($r->customerAccount->dueAmount > 0 ? $r->customerAccount->dueAmount : 0); ?>" <?php endif; ?>
                                    type="button" class="btn btn-danger ajaxPayment btn-xs btn-block text-nowrap"
                                    data-toggle="modal" data-target="#paymentModal">
                                    Payment
                                </button>
                            <?php endif; ?>

                            <a class=" btn-info btn-block btn-xs text-nowrap clear"
                                href="<?php echo e(route('getPaymentHistory', $r->id)); ?>">CID: <?php echo e($r->id); ?></a>
                        <?php else: ?>
                            <?php if(in_array('customer-recharge', $permissions)): ?>
                                <?php if(checkSettings('reseller-client-dynamic-recharge') == 'enable' && in_array('dynamic-recharge', $permissions)): ?>
                                <?php else: ?>
                                    <?php if($r->client_approval == 'approved'): ?>
                                        <button data-id="<?php echo e($r->id); ?>" type="button"
                                            class="btn btn-dark ajaxRecharge btn-xs btn-block text-nowrap">
                                            Rechage
                                        </button>
                                    <?php endif; ?>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if(globalPermission('reseller-client-billing') && in_array('view-client-account-balance', $permissions)): ?>
                                <a class=" btn-info btn-block btn-xs text-nowrap clear"
                                    href="<?php echo e(route('getPaymentHistoryOfResellerClient', $r->id)); ?>">CID:
                                    <?php echo e($r->id); ?></a>
                            <?php else: ?>
                                <span class=" btn-info btn-block btn-xs text-nowrap">CID <?php echo e($r->id); ?></span>
                            <?php endif; ?>

                        <?php endif; ?>

                        <?php if(!checkAPI() || checkSettings('api_bandwidth_usage') == 'enable'): ?>
                            <a href="<?php echo e(route('getCustomerLogHistory', $r->id)); ?>"
                                class="noprint btn btn-primary btn-xs btn-block">Log</a>
                        <?php endif; ?>
                        <?php if($r->deleted_at != null): ?>
                            <a href="<?php echo e(route('close-customer-details', $r->id)); ?>"
                                class="noprint btn btn-primary btn-xs btn-block">Details</a>
                        <?php else: ?>
                            <a href="<?php echo e(route('clients.show', $r->id)); ?>"
                                class="noprint btn btn-primary btn-xs btn-block">Details</a>
                        <?php endif; ?>

                        <?php if(checkSettings('singleInvoice') == 'enable' && $r->pop->bill_generate == 'yes'): ?>
                            <button data-id="<?php echo e($r->id); ?>"
                                class="btn btn-info btn-xs text-nowrap btn-block viewInvoice">View Invoice</button>

                            <button data-id="<?php echo e($r->id); ?>"
                                class="btn btn-danger btn-sm btn-block sendInvoice"><i class="fa fa-envelope"></i>
                                Send</button>
                        <?php endif; ?>
                        <div class="mt-2">
                            <?php if($r->deleted_at != null): ?>
                                <div class="dropdown">
                                    <button class="btn btn-primary btn-sm btn-block dropdown-toggle" type="button"
                                        id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                        aria-expanded="false">
                                        Action
                                    </button>
                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">

                                        <a href="<?php echo e(route('close-customer-details', $r->id)); ?>"
                                            class="dropdown-item">Details</a>

                                        <?php if(in_array('delete_customer_edit', $permissions)): ?>
                                            <a href="<?php echo e(route('clients.edit', $r->id)); ?>"
                                                class="dropdown-item">Edit</a>
                                        <?php endif; ?>

                                        <?php if(in_array('mac-customer_destroy', $permissions) && $r->pops->bill_generate != 'yes'): ?>
                                            <button class="dropdown-item idDestroy"
                                                data-id="<?php echo e($r->id); ?>">Delete</button>
                                        <?php endif; ?>

                                        <div class="mb-1"></div>

                                        <?php if(in_array('can-open', $permissions)): ?>
                                            <a href="<?php echo e(route('open', $r->id)); ?>"
                                                onclick="return confirm('Are you sure you want to Open the ID?');"
                                                class="confirmDisable dropdown-item bg-danger">Restore Account</a>
                                        <?php endif; ?>


                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="dropdown">



                                    <button class="btn btn-primary btn-sm btn-block dropdown-toggle" type="button"
                                        id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                        aria-expanded="false">
                                        Action
                                    </button>
                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">

                                        
                                        <?php if(in_array('add-otc', $permissions)): ?>
                                            <?php if($r->pops->bill_generate == 'yes'): ?>
                                                <?php if($r->clientsinfo->otc < 1): ?>
                                                    <button type="button" class="dropdown-item addOtc"
                                                        data-toggle="modal" data-id="<?php echo e($r->id); ?>"
                                                        data-target="#addOtc">
                                                        Add Otc
                                                    </button>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <?php if($r->pop->bill_generate == 'yes'): ?>
                                            <?php ($link = App\Http\Controllers\CompanyInfoController::baseUrl() . $r->slug); ?>

                                            <p id="client-<?php echo e($r->id); ?>" class="d-none"><?php echo e($link); ?>

                                            </p>
                                            <a href="#" class="dropdown-item"
                                                onclick="copyToClipboard(<?php echo e($r->id); ?>)">Copy Payment URL</a>

                                            <a href="<?php echo e(route('clientQrcode', $r->id)); ?>" class="dropdown-item"
                                                target="_blank">Print QR Code</a>
                                        <?php endif; ?>
                                        <a href="<?php echo e(route('clients.show', $r->id)); ?>"
                                            class="dropdown-item">Details</a>

                                        
                                        <?php if(in_array('mac-customer_edit', $permissions)): ?>
                                            <a href="<?php echo e(route('clients.edit', $r->id)); ?>"
                                                class="dropdown-item">Edit</a>
                                        <?php endif; ?>


                                        <?php if($r->is_free == 0): ?>
                                            <?php if(request()->path() == 'admin/clients' ||
                                                    request()->path() == 'admin/customer_search' ||
                                                    request()->path() == 'admin/clientSearchReport'): ?>
                                                <?php if(in_array('changeBillCycle', $permissions)): ?>
                                                    <button type="button" class="dropdown-item clientBillCycleChange"
                                                        data-toggle="modal" data-id="<?php echo e($r->id); ?>"
                                                        data-curdate=<?php echo e($r->billing_cycle); ?>

                                                        data-target="#billCycleChange">
                                                        Bill Cycle Change
                                                    </button>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <?php if(request()->path() == 'admin/clients' ||
                                                request()->path() == 'admin/customer_search' ||
                                                request()->path() == 'admin/clientSearchReport' ||
                                                request()->path() == 'admin/list/expired-Clients' ||
                                                request()->path() == 'admin/expired-Clients' ||
                                                request()->path() == 'admin/expire-customer-search'): ?>
                                            <?php if(in_array('mac-customer_edit', $permissions)): ?>
                                                <?php if($r->pop->bill_generate == 'yes' && auth()->user()->can('extend-temporary-dedline')): ?>
                                                    <button type="button" class="dropdown-item changeTemporaryExtend"
                                                        data-toggle="modal" data-id="<?php echo e($r->id); ?>"
                                                        data-tmpExtend=<?php echo e($r->payment_dadeline); ?>

                                                        data-target="#expDateExtend">Expire Date Extend
                                                    </button>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <?php if(request()->path() == 'admin/clients' ||
                                                request()->path() == 'admin/customer_search' ||
                                                request()->path() == 'admin/clientSearchReport'): ?>
                                            

                                            <?php if(in_array('change_auto_deactive_date', $permissions)): ?>
                                                <button onclick="autoDeactiveDateApply(<?php echo e($r->id); ?>)"
                                                    type="button" class="dropdown-item autoDeactiveDateChange"
                                                    data-toggle="modal" data-id="<?php echo e($r->id); ?>"
                                                    data-autoDeactive="<?php echo e(date('d-M-Y', strtotime($r->auto_deactive))); ?>"
                                                    data-target="#deactiveDateChange"
                                                    id="autoDeactiveId-<?php echo e($r->id); ?>">
                                                    Auto Deactive Date
                                                </button>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                        <?php if($r->is_free == 0): ?>
                                            <?php if(request()->path() == 'admin/clients' ||
                                                    request()->path() == 'admin/customer_search' ||
                                                    request()->path() == 'admin/clientSearchReport'): ?>
                                                <?php if(in_array('changePackage', $permissions)): ?>
                                                    <a href="" type="button"
                                                        data-clientid="<?php echo e($r->id); ?>"
                                                        class="package_change_action_btn dropdown-item"
                                                        data-toggle="modal"
                                                        data-target="#package_change_modal">Package
                                                        Change</a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>




                                        <?php if(checkSettings('schedule_package') == 'enable' && in_array('schedule-package-change', $permissions)): ?>
                                            <a href="" type="button" data-clientid="<?php echo e($r->id); ?>"
                                                class="schedule_package_change dropdown-item" data-toggle="modal"
                                                data-target="#schedule_package_change_modal">Schedule Package
                                                Change</a>
                                        <?php endif; ?>




                                        <div class="mb-1"></div>


                                        <?php if($r->clients_status == 'disable'): ?>
                                            <?php if(in_array('id-enable', $permissions)): ?>
                                                <a href="#" data-id="<?php echo e($r->id); ?>"
                                                    id="<?php echo e($r->id); ?>"
                                                    class="idEnable dropdown-item">Enable</a>
                                            <?php endif; ?>
                                        <?php endif; ?>


                                        <?php if($r->clients_status != 'disable'): ?>
                                            <?php if(in_array('id-disable', $permissions)): ?>
                                                <a href="#" data-id="<?php echo e($r->id); ?>"
                                                    id="<?php echo e($r->id); ?>"
                                                    class=" idDisable confirmDisable dropdown-item ">Disable </a>
                                            <?php endif; ?>
                                        <?php endif; ?>


                                        <?php if($r->clients_status != 'deactive'): ?>
                                            <?php if(in_array('customer-deactivated', $permissions)): ?>
                                                <a href="#" data-id="<?php echo e($r->id); ?>"
                                                    id="deactive<?php echo e($r->id); ?>"
                                                    class="id_deactive  dropdown-item">Deactive
                                                </a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <?php if($r->clients_status == 'deactive'): ?>
                                            <?php if(in_array('customer-reactivate', $permissions)): ?>
                                                <a href="#" data-id="<?php echo e($r->id); ?>"
                                                    id="reactive<?php echo e($r->id); ?>"
                                                    class="id_reactive   dropdown-item">Reactive
                                                </a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <?php if(in_array('can-close', $permissions)): ?>
                                            <?php if(request()->path() != 'admin/pending-customer'): ?>
                                                <?php if($r->deleted_at == null): ?>
                                                    <a href="#" data-id="<?php echo e($r->id); ?>"
                                                        class="idClose dropdown-item">Close</a>
                                                <?php else: ?>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                        <?php if($r->pops->bill_generate != 'yes' || $r->client_approval == 'pending'): ?>
                                            <?php if(in_array('mac-customer_destroy', $permissions)): ?>
                                                <button class="dropdown-item idDestroy"
                                                    data-id="<?php echo e($r->id); ?>">Delete</button>
                                            <?php endif; ?>
                                        <?php endif; ?>



                                        <?php if($r->ignoreMKCheck == 0): ?>
                                            <form method="POST" action="<?php echo e(route('reSyncSingleClient')); ?>">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="id" value="<?php echo e($r->id); ?>">
                                                <button
                                                    onclick="return confirm('Are you sure you want to re-sync this user ?');"
                                                    type="submit" class="dropdown-item">Re-Sync</button>
                                            </form>
                                        <?php else: ?>
                                            <button type="button" class="dropdown-item" disabled>Ignore MK :
                                                &#x2705;</button>
                                        <?php endif; ?>

                                        <?php if($r->isStatic && Auth::user()->can('static_manage')): ?>
                                            <?php echo Form::open(['method' => 'DELETE', 'route' => ['remove-buinding-static', $r->id]]); ?>

                                            <button type="submit" class="dropdown-item">Remove Mac Bind</button>
                                            <?php echo Form::close(); ?>

                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('never_disconnect')): ?>
                                            <form method="POST" action="<?php echo e(route('neverDisconnectClient')); ?>">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="id" value="<?php echo e($r->id); ?>">

                                                <?php if($r->experity_check == 'Yes'): ?>
                                                    <input type="hidden" name="experity_check" value="No">
                                                    <button
                                                        onclick="return confirm('Are you sure to never disconnect this user?');"
                                                        type="submit" class="dropdown-item">Never Disconnect</button>
                                                <?php else: ?>
                                                    <input type="hidden" name="experity_check" value="Yes">
                                                    <button
                                                        onclick="return confirm('Are you sure to Check regular process?');"
                                                        type="submit" class="dropdown-item">Check Expired</button>
                                                <?php endif; ?>

                                            </form>
                                        <?php endif; ?>
                                        <button class="dropdown-item"><a
                                                href="<?php echo e(route('printClientCopy', $r->id)); ?>"
                                                target="_blank">Print</a></button>

                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>

                    </td>
                    <td class="no-wrap ">
                        <div class="d-flex justify-content-between">


                            <div>
                                <i class="fa-solid fa-user bg-success text-light p-1 rounded-circle"
                                    aria-hidden="true" style="font-size: 0.75rem;"></i>

                                <?php echo e($r->isStatic ? $r->ip_address : $r->userid); ?>




                                <?php if(in_array('view-client-password', $permissions)): ?>
                                    <?php if(!$r->isStatic): ?>
                                        <br>
                                        <div style="margin-top: 5px !important">

                                        </div>
                                        <i class="fa fa-key bg-danger text-light p-1 rounded-circle"
                                            aria-hidden="true" style="font-size: 0.75rem;"></i>
                                        <?php echo e($r->password); ?>

                                        <br>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <?php if(checkSettings('customer_code') == 'enable'): ?>
                                    <i class="fa-solid fa-user-secret bg-warning text-light p-1 rounded-circle"></i>
                                    <?php echo e($r->customer_code ?? ''); ?>

                                <?php endif; ?>

                                <?php if($r->is_free == 1): ?>
                                    <p class="badge badge-info m-0">Free</p>
                                <?php endif; ?>


                                <?php if(request()->path() == 'admin/clientSearchReport' && checkAPI()): ?>
                                    <div class="d-flex justify-content-start">
                                        <a role="button" id="clientOnlineButton-<?php echo e($r->id); ?>"
                                            data-client-id="<?php echo e($r->id); ?>" style="cursor:pointer; ">
                                            <i class="fa-regular fa-eye bg-success text-light p-1 rounded-circle"
                                                style="font-size: 0.75rem; "></i>
                                        </a>
                                        <p class="response-paragraph"></p>
                                    </div>
                                <?php endif; ?>

                                <?php if(request()->path() == 'admin/list/close-list' ||
                                        (request()->path() == 'admin/close-search-list' && $r->deleted_at != null)): ?>
                                    <span class="btn btn-danger btn-xs">
                                        Closed at <br>
                                        <?php echo e($r->deleted_at); ?>

                                    </span>
                                <?php endif; ?>

                                <?php if(request()->path() == 'admin/list/disable-customer' || request()->path() == 'admin/disable-customer-search'): ?>
                                    <?php $__currentLoopData = $con_history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $con): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(isset($con->client_id)): ?>
                                            <?php if($r->id == $con->client_id): ?>
                                                <span class="btn btn-sm bg-danger ">
                                                    <?php echo e($con->created_at); ?>

                                                </span>
                                                <span class="d-block">
                                                    <?php if($con->details != null): ?>
                                                        Action : <?php echo e(Str::limit($con->details, 30)); ?>

                                                    <?php endif; ?>
                                                </span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>


                                <?php if(request()->path() == 'admin/clients' || request()->path() == 'admin/customer_search'): ?>
                                    <br>
                                    <?php if(checkAPI()): ?>
                                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.client-connection-status','data' => ['isStatic' => $r->isStatic,'userid' => $r->userid,'ipAddress' => $r->ip_address,'online' => $online]]); ?>
<?php $component->withName('client-connection-status'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['isStatic' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($r->isStatic),'userid' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($r->userid),'ipAddress' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($r->ip_address),'online' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($online)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>


                                        <?php if(checkSettings('showClientUpDownInfo') == 'enable'): ?>
                                            <?php if(array_key_exists($r->userid, $online['usersBandwidth'])): ?>
                                                <span>
                                                    <strong>Download⬇️</strong>
                                                    <?php echo e(number_format($online['usersBandwidth'][$r->userid]['tx-byte'] / 1048576, 2, '.', '')); ?>MB
                                                </span>
                                                <span>

                                                    <strong>Upload⬆️</strong>
                                                    <?php echo e(number_format($online['usersBandwidth'][$r->userid]['rx-byte'] / 1048576, 2, '.', '')); ?>MB
                                                </span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <?php if(isset($online) && in_array($r->userid, $online)): ?>
                                            <span class="btn btn-success btn-xs">Online</span>
                                        <?php else: ?>
                                            <span class="btn btn-danger btn-xs">Offline</span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <br>
                                    <?php if($r->ignoreMKCheck == 1): ?>
                                        <p>Ignore MK : &#x2705;</p>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                            <div>

                                <?php if(checkSettings('radius_customer_bandwidth_limit') == 'enable'): ?>
                                    <p>
                                        <span class="badge badge-warning">D⬇️ <?php if($r->down_bandwidth >= 1024): ?>
                                                <?php echo e(number_format($r->down_bandwidth / 1024, 2, '.', '')); ?>GB
                                            <?php else: ?>
                                                <?php echo e($r->down_bandwidth); ?>MB
                                            <?php endif; ?>
                                        </span>
                                    </p>

                                    <p><span class="badge badge-warning">U⬆️ <?php if($r->up_bandwidth >= 1024): ?>
                                                <?php echo e(number_format($r->up_bandwidth / 1024, 2, '.', '')); ?>GB
                                            <?php else: ?>
                                                <?php echo e($r->up_bandwidth); ?>MB
                                            <?php endif; ?>
                                        </span>
                                    </p>
                                <?php endif; ?>

                            </div>

                        </div>
                        <?php if($r->experity_check == 'No'): ?>
                            <div class="mt-2">
                                <div class=""
                                    style="display: inline-block; border: 2px solid red; color: red; font-weight: bold;
                                    text-align: center; padding: 2px 5px; border-radius: 4px; font-size: 12px; ">
                                    VIP</div>
                            </div>
                        <?php endif; ?>
                    </td>

                    <td class="cStatus<?php echo e($r->id); ?> <?php echo e(clientStatusClass($r->clients_status)); ?>">

                        <?php if($r->clients_status == 'active'): ?>
                            Active
                        <?php elseif($r->clients_status == 'deactive'): ?>
                            Deactive</span>
                        <?php elseif($r->clients_status == 'expired'): ?>
                            Expired</span>
                        <?php elseif($r->clients_status == 'disable'): ?>
                            Disabled</span>
                        <?php endif; ?>

                    </td>
                    <td class="cExpireDate<?php echo e($r->id); ?> <?php if($r->payment_dadeline == 0): ?> <?php echo e(clientStatusClass($r->clients_status)); ?> <?php endif; ?>"
                        style="min-width:140px;text-align:left; <?php if($r->payment_dadeline != 0): ?> background: #a8dadc; <?php endif; ?> ">
                        BD: <span
                            class="bdate_exp<?php echo e($r->id); ?>"><?php echo e(date('d-M-Y', strtotime($r->expire_date))); ?></span><br>
                        <?php if($r->payment_dadeline != 0): ?>
                            <span class="d-block badge badge-warning">
                                PD:
                                <?php echo e(\Carbon\Carbon::parse($r->expire_date)->addDay($r->payment_dadeline)->format('d-M-Y')); ?>

                            </span>
                        <?php else: ?>
                            PD:
                            <span
                                class="bdate_exp<?php echo e($r->id); ?>"><?php echo e(\Carbon\Carbon::parse($r->expire_date)->addDay($r->payment_dadeline)->format('d-M-Y')); ?></span>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('change-expire-date')): ?>
                            <button type="button" class="dropdown-item changeExpireDate badge badge-dark p-1"
                                data-toggle="modal" data-id="<?php echo e($r->id); ?>" data-target="#changeExpireDate">
                                Change
                            </button>
                        <?php endif; ?>

                        <?php if(checkSettings('auto_deactive_check') == 'enable'): ?>
                            <br><br>
                            <?php if(!empty($r->auto_deactive)): ?>
                                AD: <?php echo e(date('d-M-Y', strtotime($r->auto_deactive ?? ''))); ?>

                            <?php endif; ?>
                        <?php endif; ?>
                    </td>


                    <td style="min-width:190px;" class="text-center">

                        <div class="w-100 text-start">
                            <p style="font-size:14px; text-align:start;">
                                Bill Date: <?php echo e($r->billing_cycle); ?>


                                <br>
                                <?php if(isset($r->pops->bill_generate) && $r->pops->bill_generate == 'yes'): ?>
                                    Package Rate: <?php if(auth()->check() && auth()->user()->hasRole('Sub Reseller')): ?>
                                        <?php if($r->pops->subreseller == 'yes'): ?>
                                            <?php echo e($r->subpack->rate ?? 0); ?>

                                        <?php else: ?>
                                            <?php echo e($r->packages->package_rate ?? 0); ?>

                                        <?php endif; ?>
                                    <?php else: ?>
                                        <?php echo e($r->packages->package_rate ?? 0); ?>

                                    <?php endif; ?> <br>
                                    Discount: <?php echo e($r->parmanent_discount); ?> <br>
                                    Monthly Bill:
                                    <?php if(auth()->check() && auth()->user()->hasRole('Sub Reseller')): ?>
                                        <?php if($r->pops->subreseller == 'yes'): ?>
                                            <?php echo e(($r->subpack->rate ?? 0) - ($r->parmanent_discount ?? 0) >= 0 ? ($r->subpack->rate ?? 0) - ($r->parmanent_discount ?? 0) : 0); ?>

                                        <?php else: ?>
                                            <?php echo e(($r->packages->package_rate ?? 0) - ($r->parmanent_discount ?? 0) >= 0 ? ($r->packages->package_rate ?? 0) - ($r->parmanent_discount ?? 0) : 0); ?>

                                        <?php endif; ?>
                                    <?php else: ?>
                                        <?php echo e(($r->packages->package_rate ?? 0) - ($r->parmanent_discount ?? 0) >= 0 ? ($r->packages->package_rate ?? 0) - ($r->parmanent_discount ?? 0) : 0); ?>

                                    <?php endif; ?> <br>
                                    OTC : <?php echo e($r->clientsinfo->otc ?? 0); ?> <br>
                                    <?php if(isset($r->clientsinfo->otc_due)): ?>
                                        <?php if($r->clientsinfo->otc_due > 0): ?>
                                            <span class="bg-danger pl-1 pr-1"> OTC Due:
                                                <span
                                                    class="listOtcDue<?php echo e($r->id); ?>"><?php echo e($r->clientsinfo->otc_due ?? 0); ?></span></span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <?php if(globalPermission('ResellerClientOnlineRecharge')): ?>
                                        Client Bill: <?php echo e(getResellerClientPaymentAmount($r)); ?>

                                        <br>
                                        Pending Amount: <?php echo e($r->un_recharge_amount ?? 0); ?>

                                    <?php endif; ?>

                                    <?php if(globalPermission('reseller-client-billing') && in_array('view-client-account-balance', $permissions)): ?>
                                        <?php ($resellerClientBalance = isset($r->customer_account_balance_reseller) ? $r->customer_account_balance_reseller : 0); ?>

                                        <?php if($resellerClientBalance >= 0): ?>
                                            <span class="badge bg-danger">
                                                Due: <?php echo e(number_format($resellerClientBalance, 2)); ?>

                                            </span>
                                        <?php elseif($resellerClientBalance < 0): ?>
                                            <span class="badge bg-success">
                                                Advance: <?php echo e(number_format(abs($resellerClientBalance), 2)); ?>

                                            </span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </p>

                            <?php if($r->pops->bill_generate == 'yes'): ?>
                                <?php ($due_amount = isset($r->customerAccount) ? $r->customerAccount->dueAmount : 0); ?>;

                                <p class="text-light font-weight-bold text-start"
                                    <?php if($due_amount > 0): ?> style="background: #fb7185;"
                                <?php else: ?>
                                    style="background: #008000;" <?php endif; ?>>
                                    <?php if($due_amount >= 0): ?>
                                        Due:
                                    <?php else: ?>
                                        Advance:
                                    <?php endif; ?>

                                    <span class="listDue<?php echo e($r->id); ?> text-start">
                                        <?php if($due_amount >= 0): ?>
                                            <?php echo e($due_amount ?? 0); ?>

                                        <?php else: ?>
                                            <?php echo e($due_amount * -1 ?? 0); ?>

                                        <?php endif; ?>
                                    </span>
                                </p>
                            <?php endif; ?>


                        </div>
                    </td>


                    <td>

                        <?php if(in_array('show-sub-package', $permissions) && $r->pops->subreseller == 'yes'): ?>
                            <span class="d-block mb-1 badge badge-info"><?php echo e($r->subpack->name ?? ''); ?>

                                <?php if(in_array('show-sub-package-rate', $permissions)): ?>
                                    (<?php echo e($r->subpack->rate ?? ''); ?>)
                                <?php endif; ?>
                            </span>
                        <?php endif; ?>


                        <?php if(in_array('show-mother-package', $permissions)): ?>
                            <span class="d-block badge badge-info p-1"> <?php echo e($r->packages->package_name ?? ''); ?>

                                <?php if(in_array('show-motherpackage-rate', $permissions)): ?>
                                    (<?php echo e($r->packages->package_rate ?? ''); ?>)
                                <?php endif; ?>
                            </span>
                        <?php endif; ?>


                        <?php if(in_array('package_change_without_cost', $permissions)): ?>
                            <a href="" type="button" data-clientid="<?php echo e($r->id); ?>"
                                class="btn btn-success btn-sm mt-2 package_change_without_cost" data-toggle="modal"
                                data-target="#package_change_without_cost_modal">
                                Package Change
                            </a>
                        <?php else: ?>
                            <?php if(in_array('package_change_without_cost_expire', $permissions) && $r->clients_status == 'expired'): ?>
                                <a href="" type="button" data-clientid="<?php echo e($r->id); ?>"
                                    class="btn btn-success btn-sm mt-2 package_change_without_cost"
                                    data-toggle="modal" data-target="#package_change_without_cost_modal">
                                    Package Change
                                </a>
                            <?php endif; ?>
                        <?php endif; ?>


                        <?php if(checkCrmRansferPermission(request()->path())): ?>
                            <a href="" type="button" data-clientid="<?php echo e($r->id); ?>"
                                data-crmstatus="<?php echo e($r->crm_status); ?>"
                                class="d-block btn btn-success btn-sm mt-2 crm_status_change" data-toggle="modal"
                                data-target="#crm_status_change_modal">
                                <?php echo e($r->crm_status); ?> -> Transfer
                            </a>

                            <?php if($r->crm_status == 'Fiber'): ?>
                                <a href="<?php echo e(route('crm-item-return', $r->id)); ?>" type="button"
                                    class="d-block btn btn-warning btn-sm mt-2 crm_status_change">
                                    Item Return
                                </a>
                            <?php endif; ?>

                            <?php if($r->crm_status == 'Store'): ?>
                                <a href="<?php echo e(route('crm-item-return-show', $r->id)); ?>" type="button"
                                    class="d-block btn btn-warning btn-sm mt-2 crm_status_change">
                                    Show Return Item
                                </a>
                            <?php endif; ?>
                            <a href="<?php echo e(route('crm-change-history', $r->id)); ?>" type="button"
                                class="d-block btn btn-primary btn-sm mt-2 crm_status_change">
                                History
                            </a>


                            <?php if(getLastCRMDate($r->id)): ?>
                                Check Date : <?php echo e(\Carbon\Carbon::parse(getLastCRMDate($r->id))->format('d-M-Y')); ?>

                            <?php endif; ?>
                        <?php endif; ?>

                    </td>

                    <td class="no-wrap">
                        <?php if($r->pops->experity_check == 'Yes'): ?>
                            <span class="d-block badge badge-warning">
                                <?php echo e($r->pops->popname ?? ''); ?>

                            </span>
                        <?php else: ?>
                            <?php echo e($r->pops->popname ?? ''); ?>

                        <?php endif; ?>
                    </td>

                    <td>
                        <?php echo e($r->clientsinfo->clients_name ?? ''); ?>

                    </td>
                    <td>
                        <?php echo e($r->clientsinfo->contact_no ?? ''); ?>

                    </td>



                    <td style="width:350px;font-size:14px; ">
                        <div class="w-100 overflow-custome" style="max-height: 150px !important;">
                            <p id="container-<?php echo e($r->id); ?>"
                                onload="addOverFlowOnUserInfo(<?php echo e($r->id); ?>);">
                                <?php if($r->ip_address): ?>
                                    IP: <?php echo e($r->ip_address ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->mac): ?>
                                    MAC: <?php echo e($r->mac ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->distribution_point): ?>
                                    Distribution point: <?php echo e($r->distribution_point ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->connection_type): ?>
                                    Connection type: <?php echo e($r->connection_type ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->customer_type): ?>
                                    Client type: <?php echo e($r->customer_type ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->dob): ?>
                                    DOB: <?php echo e($r->clientsinfo->dob ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->father_name): ?>
                                    Father: <?php echo e($r->clientsinfo->father_name ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->mother_name): ?>
                                    Mother: <?php echo e($r->clientsinfo->mother_name ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->national_id): ?>
                                    NID: <?php echo e($r->clientsinfo->national_id ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->passport_no): ?>
                                    Passport: <?php echo e($r->clientsinfo->passport_no ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->division): ?>
                                    Division: <?php echo e($r->clientsinfo->divisions->name ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->district): ?>
                                    District: <?php echo e($r->clientsinfo->districts->name ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->thana): ?>
                                    Upazila: <?php echo e($r->clientsinfo->thanas->name ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->area): ?>
                                    Area :<?php echo e($r->clientsinfo->area ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->road_name): ?>
                                    Road Name: <?php echo e($r->clientsinfo->road_name ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->road_no): ?>
                                    Road No: <?php echo e($r->clientsinfo->road_no ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->block_sector): ?>
                                    Block/Sector: <?php echo e($r->clientsinfo->block_sector ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->building_no): ?>
                                    Building No: <?php echo e($r->clientsinfo->building_no ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->building_name): ?>
                                    Building Name: <?php echo e($r->clientsinfo->building_name ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->flat_no): ?>
                                    Flat No: <?php echo e($r->clientsinfo->flat_no ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->owner_name): ?>
                                    House Owner : <?php echo e($r->clientsinfo->owner_name ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->owner_number): ?>
                                    House Owner No: <?php echo e($r->clientsinfo->owner_number ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->other_contact): ?>
                                    Clients Other Contact : <?php echo e($r->clientsinfo->other_contact ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->email): ?>
                                    <b class="text-primary">Email :</b> <?php echo e($r->clientsinfo->email ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->client_latitude): ?>
                                    Latitude : <?php echo e($r->clientsinfo->client_latitude ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->client_longitude): ?>
                                    Longitude : <?php echo e($r->clientsinfo->client_longitude ?? ''); ?>,<br>
                                <?php endif; ?>

                                <?php if($r->clientsinfo->box): ?>
                                    Box :<?php echo e($r->clientsinfo->box ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->cable_type): ?>
                                    Cable Type :<?php echo e($r->clientsinfo->cable_type ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->required_cable != 0): ?>
                                    Cable(Meter): <?php echo e($r->required_cable ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->olt_pon): ?>
                                    OLT/PON : <?php echo e($r->clientsinfo->olt_pon ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->cable_id): ?>
                                    Cable ID : <?php echo e($r->clientsinfo->cable_id ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->cat_type): ?>
                                    Cable(CAT-5/CAT-6): <?php echo e($r->clientsinfo->cat_type ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->cat_length): ?>
                                    <?php echo e($r->clientsinfo->cat_type ?? 'CAT'); ?> Length(Meter):
                                    <?php echo e($r->clientsinfo->cat_length ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->onu_serial): ?>
                                    ONU MAC/Pon No/Serial No: <?php echo e($r->clientsinfo->onu_serial ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->olt_pon): ?>
                                    OLT No: <?php echo e($r->clientsinfo->olt_pon ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->olt_no): ?>
                                    OLT Card Slot No: <?php echo e($r->clientsinfo->olt_no ?? ''); ?>,<br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->pon_port): ?>
                                    PON Module Port No: <?php echo e($r->clientsinfo->pon_port ?? ''); ?><br>
                                <?php endif; ?>
                                <?php if($r->clientsinfo->client_latitude && $r->clientsinfo->client_longitude): ?>
                                    <span class="btn btn-danger btn-sm btn-block clear viewMap w-75 mx-auto"
                                        data-id="<?php echo e($r->clientsinfo->client_latitude); ?>,<?php echo e($r->clientsinfo->client_longitude); ?>">View
                                        Map</span>
                                <?php endif; ?>
                            </p>
                        </div>

                    </td>

                    <td class="whitespace-nowrap">
                        <strong>CD:</strong> <?php echo e(date('d-M-Y h:i:sa', strtotime($r->created_at))); ?><br>
                        <?php if($r->clientsinfo->joinDate): ?>
                            <strong>JD:</strong> <?php echo e(date('d-M-Y', strtotime($r->clientsinfo->joinDate))); ?>

                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('billing_start_time')): ?>
                            <?php if($r->billing_start_date): ?>
                                <strong>Bill Start Date:</strong> <?php echo e(date('d-M-Y', strtotime($r->billing_start_date))); ?>

                            <?php endif; ?>
                        <?php endif; ?>
                    </td>
                    <?php if(request()->path() == 'admin/list/close-list' || request()->path() == 'admin/close-search-list'): ?>
                        <td><?php echo e($r->deleted_at->format('d-M-Y h:s:a')); ?></td>
                    <?php endif; ?>
                    <td>
                        <div class="w-100 overflow-custome" style="max-height: 150px !important;">
                            <?php echo e($r->clientsinfo->remarks ?? ''); ?>

                        </div>
                    </td>

                    <?php if(request()->path() == 'admin/pending-customer'): ?>
                        <td><?php echo e($r->adminUser->name ?? ''); ?></td>
                    <?php endif; ?>


                </tr>
                <?php ($totalOtc += $r->clientsinfo->otc); ?>
                <?php ($totalMrc += $r->packages->package_rate ?? 0); ?>
                <?php ($catTotalLength += $r->clientsinfo->cat_length ?? 0); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php if(request()->path() == 'admin/list/new-join' ||
                    request()->path() == 'admin/list/close-list' ||
                    request()->path() == 'admin/close-search-list' ||
                    request()->path() == 'admin/newClientSearchReport' ||
                    request()->path() == 'admin/clientSearchReport'): ?>

        <tfoot>

            <tr>
                <?php if(request()->path() == 'admin/clientSearchReport'): ?>
                    <td></td>
                <?php endif; ?>

                <td colspan="8" style="text-align: right">Total</td>
                <?php if(auth()->user()->hasPermissionTo('source_mrc_hide')): ?>
                    <td style="text-align: right">
                        Fiber: <?php echo e($list->sum('required_cable')); ?> Meter,<br> CAT: <?php echo e($catTotalLength); ?> Meter,<br>
                        OTC:
                        <?php echo e($totalOtc); ?> Taka</td>
                <?php else: ?>
                    <td style="text-align: right">
                        Fiber: <?php echo e($list->sum('required_cable')); ?> Meter,<br> CAT: <?php echo e($catTotalLength); ?> Meter,<br>
                        OTC:
                        <?php echo e($totalOtc); ?> Taka <br> MRC: <?php echo e($totalMrc); ?> TK</td>
                <?php endif; ?>
                <?php if(checkSettings('radius_customer_bandwidth_limit') == 'enable'): ?>
                    <br>
                    <td style="text-align: right">
                        <p>
                            <span class="badge badge-warning">Total D⬇️
                                <?php echo e(number_format($list->sum('down_bandwidth') / 1024, 2, '.', '')); ?> GB
                            </span>
                        </p>

                        <p><span class="badge badge-warning">Total U⬆️
                                <?php echo e(number_format($list->sum('up_bandwidth') / 1024, 2, '.', '')); ?> GB
                            </span>
                        </p>
                        <p><span class="badge badge-warning">Total ⬆️
                                <?php echo e(number_format(($list->sum('down_bandwidth') + $list->sum('up_bandwidth')) / 1024, 2, '.', '')); ?>

                                GB
                            </span>
                            <?php if(isset($package_limit)): ?>
                                <p><span class="badge badge-danger">Total Limit ⬆️
                                        <?php echo e(number_format($package_limit / 1024, 2, '.', '')); ?> GB
                                    </span>
                                </p>
                            <?php endif; ?>
                    </td>

                <?php endif; ?>


                <td colspan="2"></td>

            </tr>
        </tfoot>
        <?php endif; ?>
        </tbody>
        </table>
        <?php if(request()->path() == 'admin/clients'): ?>
            <script>
                // Add loading indicator for expire date sorting
                document.addEventListener('DOMContentLoaded', function() {
                    const expireSortLink = document.querySelector('th a[href*="sort=expire_date"]');

                    if (expireSortLink) {
                        expireSortLink.addEventListener('click', function() {
                            // Add loading state
                            this.style.opacity = '0.6';
                            this.style.pointerEvents = 'none';

                            // Remove loading state after a short delay
                            setTimeout(() => {
                                this.style.opacity = '1';
                                this.style.pointerEvents = 'auto';
                            }, 500);
                        });
                    }
                });
            </script>
        <?php endif; ?>


        <?php if(request()->path() == 'admin/clientSearchReport'): ?>
            <script>
                $(document).ready(function() {

                    $('[id^="clientOnlineButton"]').on('click', function() {

                        var clientUserId = $(this).data('client-id');
                        var url = '<?php echo e(route('clientOnlineStatus', ['clientUserId' => ':clientUserId'])); ?>';
                        url = url.replace(':clientUserId', clientUserId);

                        var clickedButton = $(this);

                        var responseParagraph = $(this).next('.response-paragraph');

                        $.ajax({
                            type: 'GET',
                            url: url,

                            success: function(response) {

                                responseParagraph.text(response.ip_address);
                                clickedButton.hide();
                                if (response.ip_address == 'Offline') {
                                    responseParagraph.css({
                                        'background-color': '#ea580c',
                                        'padding': '1.5px',
                                        'color': '#fff',
                                    })
                                } else {
                                    responseParagraph.css({
                                        'background-color': '#16a34a',
                                        'padding': '1.5px',
                                        'color': '#fff',
                                    })
                                }
                            },
                            error: function(error) {

                                console.error(error);
                            }
                        });
                    });
                });
            </script>
        <?php endif; ?>

    </div>
</div>




<style>
    /* sidebar scroller start*/
    .overflow-custome {
        overflow-y: scroll;
    }

    .overflow-custome::-webkit-scrollbar-track {
        -webkit-box-shadow: inset 0 0 6px rgba(56, 15, 15, 0.3);
        background-color: #f5f5f5;
    }

    .overflow-custome::-webkit-scrollbar {
        width: 6px;
        background-color: #f5f5f5;
    }

    .overflow-custome::-webkit-scrollbar-thumb {
        background-color: #330a0a;
        border: 2px solid #555555;
    }

    /* sidebar scroller end*/
    if (request()->path()=='admin/clients') {

        /* Sorting styles for Expire column */
        .table th a {
            color: white !important;
            text-decoration: none !important;
            display: inline-block;
        }

        .table th a:hover {
            color: #ffc107 !important;
            text-decoration: none !important;
        }

        .table th a i {
            margin-left: 5px;
            font-size: 12px;
        }

        .table th a .fa-sort {
            opacity: 0.5;
        }

        .table th a:hover .fa-sort {
            opacity: 1;
        }

        /* Sorting styles for Expire column */
    }
</style>

<style>
    .scrollbar {
        /* max-height: 600px;
        min-height: 600px;
        overflow-x: auto;
        overflow-y: auto;
        border: 1px solid #ddd; */
    }

    .table {
        /* width: 100%;
        table-layout: auto;
        border-collapse: collapse; */
    }

    .table th,
    .table td {
        /* padding: 8px;
        text-align: left;
        border: 1px solid #ddd; */
    }

    .table thead th {
        /* position: sticky;
        top: 0; */
        /* background-color: #212529; */
        /* z-index: 2; */
    }
</style>
<?php /**PATH /var/www/html/pbn/radius-circle/resources/views/clients/customer_search.blade.php ENDPATH**/ ?>