<?php

namespace App\Http\Controllers;

use App\Models\Client;
use Illuminate\Http\Request;

class DisconnectApiUserController extends Controller
{
    public function disconnectUsers()
    {
        $clients = Client::where('clients_status', 'expired')->get();

        $groupedClients = $clients->groupBy(function($client) {
            return $client->pops->nas_id;
        })->map(function($clients) {
            $nas = $clients->first()->pops->nas;
            return [
                'mikrotik' => [
                    'id' => $nas->id,
                    'nasname' => $nas->nasname,
                    'mikrotick_user' => $nas->mikrotick_user,
                    'mikrotick_user_password' => $nas->mikrotick_user_password,
                    'mikrotick_port' => $nas->mikrotick_port,
                ],
                'users' => $clients->map(function($client) {
                    return [
                        'username' => $client->userid,
                    ];
                })
            ];
        });


        $groupedClients = $clients->groupBy(function($client) {
            return $client->pops->nas_id;
        })->map(function($clients) {
            $nas = $clients->first()->pops->nas;
            return [
                'mikrotik' => [
                    'host' => $nas->nasname,
                    'username' => $nas->mikrotick_user,
                    'password' => $nas->mikrotick_user_password,
                    'port' => $nas->mikrotick_port,
                ],
                'users' => $clients->map(function($client) {
                    return [
                        'username' => $client->userid
                    ];
                })->values()->all()
            ];
        })->values()->all();



        return response()->json([
            'clients' => $groupedClients,
        ]);


    }
}
