<?php

namespace App\Models\map;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Fiber extends Model
{
    use HasFactory;
    protected $table = "fiber_map";

    protected $fillable = [
        "cable_id",
        "tube_id",
        "fiber_number",

        "parent_fiber_id",
        "parent_component_type",
        "parent_component_id",
        "parent_component_port_id",

        "child_fiber_id",
        "child_component_type",
        "child_component_id",
        "child_component_port_id",
    ];

    public function cable()
    {
        return $this->belongsTo(Cable::class, "cable_id");
    }
    public function tube()
    {
        return $this->belongsTo(Tube::class, "tube_id");
    }

    public function parentFiber()
    {
        return $this->belongsTo(Fiber::class, "parent_fiber_id")->with("parentFiber", "cable:id,name", "parentComponent.device", "parentComponent.splitter", "childComponent.device");
    }
    public function childFiber()
    {
        return $this->belongsTo(Fiber::class, "child_fiber_id")->with("childFiber", "cable:id,name", "parentComponent.device", "parentComponent.splitter", "childComponent.device");
    }
    public function parentDevice()
    {
        return $this->belongsTo(Device::class, "parent_component_id");
    }

    public function parentComponent()
    {
        return $this->morphTo(null, 'parent_component_type', 'parent_component_id');
    }

    public function childComponent()
    {
        return $this->morphTo(null, 'child_component_type', 'child_component_id');
    }
}
