<?php

namespace App\Http\Controllers;

use App\Exports\AllClientExport;
use App\Exports\ClientsExport;
use App\Exports\DeactiveCloseExport;
use App\Exports\DeactiveExport;
use App\Exports\FileExport;
use App\Exports\LocalUserContactNoExport;
use App\Exports\SyncExport;
use App\Models\Client;
use App\Models\MikcrotikClientList;
use App\Models\Pop;
use App\Models\Reseller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;

class FileExportController extends Controller
{
    public function exportList()
    {
        $data =  Client::list()->where('clients_status', 'active');

        // $column = DB::select("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'clientsinfo'");
        // dd($column);

        return view('clients.exportList', [
            'reseller'   =>  Reseller::resellerList()->get(),
            'list' => $data->get()
        ]);
    }

    public function exportListDown(Request $request)
    {
        // dd($request->all());
        $array = [
            'id' => $request->userId,
            'name' => $request->name,
            'password' => $request->password,
            'date' => $request->date,
            'speed' => $request->speed,
            'status' => $request->status,
            'remarks' => $request->remarks,
            'expire_date' => $request->expire_date,
        ];
        // dd($array['id']);

        $data[] = '';
        if ($request->reseller_id == 'all') {

            if ($request->client_status == 'all') {
                $data = Client::list()->get();
            } else {
                $data = Client::list()->where('clients_status', $request->client_status)->get();
            }
            // dd($request->client_status);
            return Excel::download(new FileExport($data, $array), 'all_users.csv');
        } else if ($request->reseller_id != null && $request->pop != null) {

            if ($request->pop == 'all') {
                if ($request->client_status == 'all') {

                    $data = Client::list()->whereHas('pop.reseller', function ($query) use ($request) {
                        $query->where('id', $request->reseller_id);
                    })->get();
                } else {
                    $data = Client::list()->whereHas('pop.reseller', function ($query) use ($request) {
                        $query->where('id', $request->reseller_id);
                    })->where('clients_status', $request->client_status)->get();
                }

                $reseller = Reseller::find($request->reseller_id);
                $name = $reseller->name . ".csv";

                return Excel::download(new FileExport($data, $array), $name);
            } else {

                if ($request->client_status == 'all') {
                    $data = Client::list()->where('pop_id', $request->pop)->get();
                } else {
                    $data = Client::list()->where('pop_id', $request->pop)->where('clients_status', $request->client_status)->get();
                }
                $pop = Pop::find($request->pop);
                $name = $pop->popname . ".csv";

                return Excel::download(new FileExport($data, $array), $name);
            }
        } else {

            Toastr::error("Please Select Pop");
            return redirect()->route('exportList');
        }
    }

    public function allLocalCustomerNumber()
    {
        $data = DB::select("SELECT clientsinfo.contact_no  FROM clientsinfo
        left join clients on clientsinfo.client_id = clients.id
        left join pops on clients.pop_id = pops.id
        left join resellers on pops.reseller_id = resellers.id
        where resellers.reseller_type = 'own'");

        return Excel::download(new LocalUserContactNoExport($data), 'all_users_no.csv');

        Toastr::success("Exported Successfully");
        return back();
    }

    public function clientExportImportList()
    {
        return view('clients.exportImportList');
    }

    public function clientExportImportDown(Request $request)
    {
        $data[] = '';

        if ($request->reseller == 'all') {
            $data = Client::list()->get();
            return Excel::download(new AllClientExport($data), 'all_users.csv');
        } else if ($request->reseller != null && $request->pop != null) {

            if ($request->pop == 'all') {
                $data = Client::list()->whereHas('pop.reseller', function ($query) use ($request) {
                    $query->where('id', $request->reseller);
                })->get();

                $reseller = Reseller::find($request->reseller);
                $name = $reseller->name . ".csv";
                return Excel::download(new AllClientExport($data), $name);
            } else {
                $data = Client::list()->where('pop_id', $request->pop)->get();
                $pop = Pop::find($request->pop);
                $name = $pop->popname . ".csv";
                return Excel::download(new AllClientExport($data), $name);
            }
        } else {
            Toastr::error("Please Select POP");
            return redirect()->route('clientExportImportList');
        }
    }

    public function synclistDownload(Request $request)
    {
        if ($request->excel == "yes") {

            $data[] = '';
            $data = MikcrotikClientList::get();
            return Excel::download(new SyncExport($data), 'sync-list.csv');
        }
    }

    public function deactiveClientExport(Request $request)
    {
        $searchData = $request->session()->get('deactive_customer_search_result');
        // dd($searchData);

        return Excel::download(new DeactiveExport($searchData), 'deactive_users.csv');
    }

    public function closeClientListExport(Request $request)
    {
        $searchData = $request->session()->get('close_customer_search_result');
        // dd($searchData);

        return Excel::download(new DeactiveCloseExport($searchData), 'close_users.csv');
    }
}
