<?php

namespace App\Http\Controllers;

use App\Jobs\BillGenerateUpdateJob;
use App\Models\BillGenerate;
use App\Models\Billpayment;
use App\Models\Client;
use App\Models\Clientsinfo;
use App\Models\CustomerAccount;
use App\Models\OtcPaymentLog;
use App\Models\ReselleBalanceLogReport;
use App\Models\ResellerCommissionReference;
use App\Models\SubResellerBalanceLogReport;
use App\Services\PaymentDeleteService;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BillDeleteController extends Controller
{
    public function billDeleteBillByBillPayment(request $request, $id, $authId = null)
    {


        DB::beginTransaction();
        try {

            $description = '';

            $bill = BillGenerate::find($id);

            if (checkSettings('otc_payment_with_generale_payment') == 'enable' && $bill->billing_type == 'otc') {
                OtcPaymentLog::where('bill_id', $bill->id)->delete();
            }

            if ($bill->billing_type == 'otc') {
                $client = Client::with('pops', 'pops.reseller')->withTrashed()->where('id', $bill->client_id)->first();
                $client_info = Clientsinfo::where('client_id', $client->id)->first();

                if ($client_info->otc_due != $bill->bill_amount) {
                    Toastr::error("Please delete the otc payment from payment history of this bill generate");
                    return back();
                } else {

                    (new ReselleBalanceLogReport())->resellerBalanceAdjust($client, $bill->bill_amount, 'OTC Delete amount : ' . $bill->bill_amount);

                    if ($client->pops->subreseller == 'yes') {
                        (new SubResellerBalanceLogReport())->subResellerBalanceAdjust($client, $bill->bill_amount, 'OTC Delete amount : ' . $bill->bill_amount);
                    }

                    $description = 'OTC Delete amount : ' . $bill->bill_amount;

                    $client_info->otc = 0;
                    $client_info->otc_due = 0;
                    $client_info->save();
                }
            } elseif ($bill->billing_type == 'new') {

                $client = Client::with('pops', 'pops.reseller')->withTrashed()->where('id', $bill->client_id)->first();

                (new ReselleBalanceLogReport)->resellerBalanceAdjust($client, $bill->bill_amount, 'New Customer Entry Delete; amount : ' . $bill->bill_amount);

                if ($client->pops->subreseller == 'yes') {
                    (new SubResellerBalanceLogReport)->subResellerBalanceAdjust($client, $bill->bill_amount, 'New Customer Entry Delete; amount : ' . $bill->bill_amount);
                }

                $description = 'New Delete amount : ' . $bill->bill_amount;
            } else {
                $description = $bill->billing_type . ' bill deleted: ' . $bill->bill_amount;
            }

            $clientAccount = CustomerAccount::where('client_id', $bill->client_id)->first();

            $clientAccount->decrement('dueAmount', $bill->bill_amount);
            $clientAccount->decrement('totalBillAmount', $bill->bill_amount);


            $bill->description = $description . ' | Previous description : ' . $bill->description;
            $bill->bill_amount = 0;
            $bill->paid_amount = 0;
            $bill->parmanent_discount = 0;
            $bill->billing_type = 'deleted';
            $bill->deleted_at = Carbon::now();
            $bill->deleted_by = auth()->user()->id ?? $authId;
            $bill->save();

            $reseller_commission = ResellerCommissionReference::where('bill_generate_id', $bill->id)->first();
            if ($reseller_commission && $reseller_commission->bill_generate_id != null) {
                $reseller_commission->actions = $reseller_commission->actions . " bill deleted";
                $reseller_commission->received_amount = 0;
                $reseller_commission->save();
            }

            $payments = Billpayment::where('bill_ids',$id)->get();
            foreach($payments as $payment)
            {
                (new PaymentDeleteService())->delete($payment->id);
            }



            DB::commit();


            return redirect()->back();
        } catch (\Exception $e) {

            dd($e);
            Toastr::error("some Problem Happen");
            DB::rollback();
        }
    }
}
