  <div class="card">
      <div class="card-body">
          <a href="{{ route('tokenExport') }}" class="btn btn-sm btn-info">Download CSV</a>
          <div class="col-md-2">Total: {{ $r->count() }}</div>
          <div class="table-responsive">
              <table id="dataTable" class="table table-bordered">
                  <thead>
                      <tr>
                          <th></th>
                          <th scope="col" style="min-width: 220px"> Token
                          </th>
                          <th scope="col" class="col">
                              C.ID
                          </th>
                          <th scope="col" class="col">Username</th>
                          <th scope="col" class="col">Creator</th>
                          <th scope="col" class="col">
                              Package
                          </th>
                          <th scope="col" class="col">
                              Reseller
                          </th>
                          <th scope="col" class="col">
                              POP
                          </th>
                          <th scope="col" class="col" style="min-width: 180px">
                              Date
                          </th>
                          <th scope="col" class="col" style="min-width: 110px">
                              Code
                          </th>
                          <th scope="col" class="col">
                              Description</th>
                          <th scope="col" class="col">Source</th>
                          <th scope="col" class="col">Reporter</th>
                          <th scope="col" class="col">
                              Assigned
                          </th>
                          <th scope="col" class="col">
                              Token Type
                          </th>
                          <th scope="col" class="col" style="min-width: 110px">
                              Status
                          </th>
                          <th scope="col" class="col" style="min-width: 110px">
                              Remarks/Close Reason
                          </th>
                          <th scope="col" class="col">
                              Closer
                          </th>
                          <th scope="col" class="col">
                              R.Contact
                          </th>
                          <th>
                              Remote
                          </th>
                          <th>
                              Auto Reboot
                          </th>
                      </tr>
                  </thead>
                  <tbody>
                      {{-- @dd($r) --}}
                      @foreach ($r as $item)
                          <tr>
                              <td style="padding-left: 2px;padding-right: 2px;max-width:70px">
                                  <div class="dropdown">
                                      <button class="btn  dropdown-toggle" type="button" id="dropdownMenuButton"
                                          data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                          <i class="ml-3 far fas fa-list nav-icon" style="font-size: 10px"></i>
                                      </button>
                                      <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                          @can('close-token')
                                              @if ($item->employee != null)
                                                  <button type="button" class="btn btn-info btn-small close_token_btn"
                                                      data-toggle="modal" data-target="#closeTokenModel">Close
                                                      Token</button>
                                              @endif
                                          @endcan
                                          @can('assign-token')
                                              @if ($item->employee == null)
                                                  <button type="button"
                                                      class="btn btn-block btn-info btn-small assign_token_btn"
                                                      data-toggle="modal" data-target="#searchassignTokenModel">Assign
                                                      Token</button>
                                              @else
                                                  <button type="button"
                                                      class="btn btn-block btn-info btn-small re_assign_token_btn"
                                                      data-toggle="modal" data-target="#reAssignTokenModel">Re-Assign
                                                      Token</button>
                                              @endif
                                          @endcan

                                          <button type="button" class="btn btn-block btn-info btn-small add_note"
                                              data-toggle="modal" data-target="#addNoteModel">Note</button>
                                      </div>
                                  </div>
                              </td>
                              <td class="d-none token_id_of_table">{{ $item->id }}</td>
                              <td style="padding-left: 2px;padding-right: 2px;max-width:150px">
                                  <span class="badge badge-success"> T.ID : </span> {{ $item->token }} <br>
                                  <span class="badge badge-info"> C.T : </span>
                                  {{ date('d-M-Y g:i: a ', strtotime($item->created_at)) }} <br>
                                  @if ($item->assign_time)
                                      <span class="badge badge-warning"> A.T : </span>
                                      {{ date('d-M-Y g:i: a ', strtotime($item->assign_time)) }} <br>
                                      @if ($item->close_time)
                                          <span class="badge badge-danger"> C.T : </span>
                                          {{ date('d-M-Y g:i: a ', strtotime($item->close_time)) }} <br>
                                      @else
                                          {{ $item->close_time ? 'Closed' . dateTimeDifferent(now(), $item->assign_time) : 'Token Assigned ' . dateTimeDifferent(now(), $item->assign_time) . ' ago Not Closed' }}
                                          <br>
                                      @endif
                                  @else
                                      {{ $item->assign_time ? 'Assigned' . dateTimeDifferent(now(), $item->created_at) : 'Token Created ' . dateTimeDifferent(now(), $item->created_at) . ' ago Not assigned' }}
                                      <br>
                                  @endif
                                  <span class="badge badge-dark add_note" role="button" data-toggle="modal"
                                      data-target="#addNoteModel"> Show Note</span> <br>
                              </td>
                              <td>{{ $item->clientId }}</td>
                              <td>{{ $item->userid }}</td>
                              <td>
                                  {{ $item->createBy }}
                                  @if ($item->createByClient ?? '')
                                      <span class="badge badge-danger">{{ $item->createByClient ?? '' }}</span>
                                  @endif
                              </td>
                              <td>
                                  {{ $item->package_name }}
                              </td>
                              <td>
                                  {{ $item->reseller }}
                              </td>
                              <td>
                                  {{ $item->popname }}
                              </td>
                              <td>
                                  {{ date('d-M-Y g:i: a ', strtotime($item->created_at)) }}
                              </td>
                              <td>
                                  {{ $item->code }}
                              </td>
                              <td>
                                  {{ $item->description }}</td>
                              <td>
                                  @if ($item->token_source == 'CRM')
                                      <span class="btn btn-info btn-xs">{{ $item->token_source }}</span>
                                  @else
                                      {{ $item->token_source }}
                                  @endif
                              </td>
                              <td>
                                  {{ $item->reportedBy }}
                              </td>
                              <td>
                                  {{ $item->employee }}
                              </td>
                              <td>
                                  {{ $item->token_type ?? '' }}
                              </td>
                              <td>
                                  @if ($item->status == 'Active')
                                      {{ 'Open' }}
                                  @else
                                      {{ 'Closed' }}
                                      @if ($item->close_time)
                                          <br> Token close time :
                                          {{ dateTimeDifferent($item->close_time, $item->created_at) }}
                                      @endif
                                  @endif

                              </td>
                              <td>
                                  {{ $item->remarks }} <br> <span class="badge badge-info">P Loss:</span>
                                  {{ $item->ping_loss }} <br> <span class="badge badge-info">O Power:</span>
                                  {{ $item->optical_power }}
                              </td>
                              <td>
                                  {{-- {{ $item->closer->name ?? '' }} --}}
                                  {{ $item->closedBy }}
                              </td>
                              <td>
                                  {{ $item->reporterContact }}
                              </td>
                              <td>
                                  @if ($item->remote == 1)
                                      <span class="badge badge-success">Yes</span>
                                  @else
                                      <span class="badge badge-danger">No</span>
                                  @endif
                              </td>
                              <td>
                                  @if ($item->autoreboot == 1)
                                      <span class="badge badge-success">Yes</span>
                                  @else
                                      <span class="badge badge-danger">No</span>
                                  @endif
                              </td>
                          </tr>
                      @endforeach
                  </tbody>
              </table>
          </div>

          {{-- <div class="p-5">
                        {{ $list->links() }}
        </div> --}}
      </div>
  </div>

  <script>
      $(document).ready(function() {
          $('.assign_token_btn').click(function() {
              var token_id = $(this).parents("tr").find(".token_id_of_table").text();
              // console.log(token_id);
              $('#id_token_assign_model').val(token_id);
          });

          $('.re_assign_token_btn').click(function() {
              var token_id = $(this).parents("tr").find(".token_id_of_table").text();
              // console.log(token_id);
              $('#id_token_re_assign_model').val(token_id);
          });

          $('.close_token_btn').click(function() {
              var token_id = $(this).parents("tr").find(".token_id_of_table").text();
              // console.log(token_id);
              $('#id_token_close_model').val(token_id);
          });

          function addToTokenNoteTable(id, note, created_by, type, created_at, delete_permission) {
              let delete_btn = '';
              if (delete_permission == false) {
                  delete_btn = 'd-none'
              }
              let note_for = type;
              if (type == 'employee') {
                  note_for = 'Employee';
              } else {
                  note_for = 'Customer';
              }
              let d = moment(created_at).format('YYYY-MM-DD hh:mm:ss A');

              $('#token_note_table tbody').append(
                  '<tr>' +
                  '<td>' + id + '</td>' +
                  '<td><strong >' + note_for + '</strong></td>' +
                  '<td>' + d + '</td>' +
                  '<td>' + note + '</td>' +
                  '<td>' + created_by + '</td>' +
                  '<td class=' + delete_btn +
                  '><lable style="width: 40px" id="btnCancle" step=".01" class="btn btn-danger float-right">-</lable></td>' +
                  '</tr>'
              );
          }

          function addToTokenNoteShowTable(id, note, created_by, type, created_at, delete_permission) {
              let delete_btn = '';
              if (delete_permission == false) {
                  delete_btn = 'd-none'
              }
              let note_for = type;
              if (type == 'employee') {
                  note_for = 'Employee';
              } else {
                  note_for = 'Customer';
              }
              $('#token_note_table_show tbody').append(
                  '<tr>' +
                  '<td>' + id + '</td>' +
                  '<td><strong >' + note_for + '</strong></td>' +
                  '<td>' + created_at + '</td>' +
                  '<td>' + note + '</td>' +
                  '<td>' + created_by + '</td>' +
                  '<td class=' + delete_btn +
                  '><lable style="width: 40px" id="btnCancle" step=".01" class="btn btn-danger float-right">-</lable></td>' +
                  '</tr>'
              );
          }

          $('.add_note').click(function() {
              var token_id = $(this).parents("tr").find(".token_id_of_table").text();
              $('#add_modal_token_id').val(token_id);
              $.ajax({
                  type: "GET",
                  url: '{{ route('get-token-note') }}',
                  data: {
                      token_id: token_id
                  },
                  success: function(res) {

                      $('#token_note_table tbody').empty();
                      let list = res.token_notes;
                      let delete_permission = res.token_note_delete;
                      list.forEach(element => {
                          addToTokenNoteTable(element.id, element.note, element.user
                              .name, element.note_type, element.created_at,
                              delete_permission);
                      });
                  }
              });
          });

          $(document).on("click", "#btnCancle", function() {
              let token_note_id = $(this).parents("tr").find("td").eq(0).text();
              $(this).closest("tr").remove();

              $.ajax({
                  type: "POST",
                  url: '{{ route('delete-token-note') }}',
                  data: {
                      token_note_id: token_note_id
                  },
                  success: function(res) {
                      if (res == 1) {
                          toastr.success('Note Deleted Successfully');
                      }
                  }
              });
          });

      });
  </script>
