<?php

namespace App\Services;

use App\Classes\MikrotikService\SyncWithMk;
use App\Models\Client;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class RadiusClientSync
{
    public function syncSingleRadiusClient($id)
    {

        $client = Client::with('pops.nas', 'packages')->where('id', $id)->first();
        if ($client) {

            $isExpire = (new SyncWithMk())->isExpire($client);

            // i want if client is disable or deactive then $checkActive will be false
            $checkActive = ($client->is_free == 1 || !$isExpire || $client->pops->experity_check == "Yes" || $client->experity_check == "No");

            $checkDisableOrDeactive = $client->clients_status == 'disable' || $client->clients_status == 'deactive';

            $checkEnable = ($checkActive && !$checkDisableOrDeactive);
            // check if client is active then add := in reccheck table and also check if client is free or not
            if ($checkEnable) {

                $op = ':=';

                DB::table('radcheck')->updateOrInsert(
                    [
                        'username' => $client->userid,
                        'attribute' => 'Cleartext-Password'
                    ],
                    [
                        'op' => $op,
                        'value' => $client->password
                    ]
                );

                DB::table('radcheck')->updateOrInsert(
                    [
                        'username' => $client->userid,
                        'attribute' => 'NAS-IP-Address'
                    ],
                    [
                        'op' => $op,
                        'value' => $client->pops->nas->nasname
                    ]
                );



                DB::table('radusergroup')->updateOrInsert(
                    ['username' => $client->userid], // where clause
                    [
                        'groupname' => $client->packages->id,
                        'priority' => 1
                    ] // values to update/insert
                );

                if ($client->ipv6 && checkSettings('ipv_6_for_radius') == 'enable') {
                    DB::table('radreply')->updateOrInsert(
                        [
                            'username' => $client->userid,
                            'attribute' => 'Framed-IPv6-Prefix'
                        ],
                        [
                            'op' => ':=',
                            'value' => $client->ipv6
                        ]
                    );
                } else {
                    DB::table('radreply')->where('username', $client->userid)->where('attribute', 'Framed-IPv6-Prefix')->delete();
                }

                if ($client->mac && globalPermission('mac_address_check_radius_system')) {
                    // check if mac address is valid mac or not

                    if (filter_var($client->mac, FILTER_VALIDATE_MAC)) {

                        DB::table('radcheck')->updateOrInsert(
                            [
                                'username' => $client->userid,
                                'attribute' => 'Calling-Station-Id'
                            ],
                            [
                                'op' => '==',
                                'value' => $client->mac
                            ]
                        );
                    }
                } else {

                    DB::table('radcheck')->where('username', $client->userid)->where('attribute', 'Calling-Station-Id')->delete();
                }

                if ($client->ip_address != null && filter_var($client->ip_address, FILTER_VALIDATE_IP)) {


                    DB::table('radreply')->insert([
                        'username'  => $client->userid,
                        'attribute' => 'Framed-IP-Address',
                        'op'        => ':=',
                        'value'     => $client->ip_address
                    ]);

                    DB::table('radreply')->insert([
                        'username'  => $client->userid,
                        'attribute' => 'Service-Type',
                        'op'        => ':=',
                        'value'     => 'Framed-User'
                    ]);
                }

                if (!filter_var($client->ip_address, FILTER_VALIDATE_IP)) {
                    DB::table('radreply')->where('username', $client->userid)->where('attribute', 'Framed-IP-Address')->delete();
                    DB::table('radreply')->where('username', $client->userid)->where('attribute', 'Service-Type')->delete();
                }
            } else {
                // check if client is expire then add != in reccheck table and also change client status to expire

                $op = globalPermission('RadiusExpiration') ? ':=' : '!=';

                if (globalPermission('RadiusExpiration')) {
                    DB::table('radcheck')
                        ->updateOrInsert(
                            [
                                'username' => $client->userid,
                                'attribute' => 'Expiration',
                                'op' => ':=',
                                'value' => "23 Sep 2004 12:00"
                            ]
                        );
                }else{
                    DB::table('radcheck')->where('username', $client->userid)->where('attribute', 'Expiration')->delete();
                }



                DB::table('radcheck')->updateOrInsert(
                    [
                        'username' => $client->userid,
                        'attribute' => 'Cleartext-Password'
                    ],
                    [
                        'op' => $op,
                        'value' => $client->password
                    ]
                );

                DB::table('radcheck')->updateOrInsert(
                    [
                        'username' => $client->userid,
                        'attribute' => 'NAS-IP-Address'
                    ],
                    [
                        'op' => $op,
                        'value' => $client->pops->nas->nasname
                    ]
                );




                DB::table('radusergroup')->updateOrInsert(
                    ['username' => $client->userid], // where clause
                    [
                        'groupname' => $client->packages->id,
                        'priority' => 1
                    ] // values to update/insert
                );

                DB::table('radreply')->where('username', $client->userid)->where('attribute', 'Framed-IP-Address')->delete();
                DB::table('radreply')->where('username', $client->userid)->where('attribute', 'Service-Type')->delete();
                DB::table('radreply')->where('username', $client->userid)->where('attribute', 'Framed-IPv6-Prefix')->delete();
            }

            // check if client has mac address then add in radcheck table


        }
    }
}
