<?php

namespace App\Http\Controllers\Map;

use App\Http\Controllers\Controller;
use App\Models\map\Onu;
use Illuminate\Http\Request;

class OnuController extends Controller
{

    public function index()
    {
        return Onu::all();
    }


    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                "name" => "required|string",
                "cluster_id" => "required|integer",
                "serial_number" => "nullable|string",
                "manufactures" => "nullable|string",
                "model" => "nullable|string",
                "remarks" => "nullable|string",
                "mac_address" => "nullable|string"

            ]
        );

        $createdOnu = Onu::create([
            "name" => $request->name,
            "cluster_id" => $request->cluster_id,
            "serial_number" => $request->serial_number,
            "manufactures" => $request->manufactures,
            "model" => $request->model,
            "remarks" => $request->remarks,
            "mac_address" => $request->mac_address,
            "type" => "onu"

        ]);

        return $createdOnu;
    }


    public function show(Onu $onu)
    {
        return $onu;
    }

    public function detail(Onu $onu)
    {
        return $onu->load(
            "opticalConnectedComponent.device:name,id,manufactures,model,cluster_id,type",
            "opticalConnectedComponent.splitter:name,id,split_ratio,type",

            "lanConnectedComponent.device:name,id,manufactures,model,cluster_id,type",

            "fiber:fiber_number,id,cable_id",
            "fiber.cable:name,id,type"
        );
    }


    public function update(Request $request, Onu $onu)
    {
        $this->validate(
            $request,
            [
                "name" => "required|string",
                "serial_number" => "nullable|string",
                "manufactures" => "nullable|string",
                "model" => "nullable|string",
                "remarks" => "nullable|string",
                "mac_address" => "nullable|string"

            ]
        );

        $onu->name = $request->name;
        $onu->serial_number = $request->serial_number;
        $onu->manufactures = $request->manufactures;
        $onu->model = $request->model;
        $onu->remarks = $request->remarks;
        $onu->mac_address = $request->mac_address;

        $onu->save();

        return $onu;
    }


    public function destroy(Onu $onu)
    {
        $loadedOnu = $this->show($onu);

        if ($loadedOnu->optical_connected_component_type || $loadedOnu->lan_connected_component_type || $loadedOnu->fiber_id) {
            return response()->json(["message" => "Onu is connected to other components"], 400);
        }

        $loadedOnu->delete();
        return Response()->json([
            "message" => "Onu deleted successfully"
        ]);
    }

    public function disconnectComponent(Request $request, Onu $onu)
    {
        $loadedOnu = $onu->load("opticalConnectedComponent", "lanConnectedComponent", "fiber");

        if ($request->type === "optical") {
            $loadedOnu->opticalConnectedComponent->connected_component_type = null;
            $loadedOnu->opticalConnectedComponent->connected_component_id = null;
            $loadedOnu->opticalConnectedComponent->save();

            $loadedOnu->optical_connected_component_id = null;
            $loadedOnu->optical_connected_component_type = null;
        } else if ($request->type === "lan") {
            $loadedOnu->lanConnectedComponent->connected_component_type = null;
            $loadedOnu->lanConnectedComponent->connected_component_id = null;

            $loadedOnu->lan_connected_component_id = null;
            $loadedOnu->lan_connected_component_type = null;
            $loadedOnu->lanConnectedComponent->save();
        } else if ($request->type === "fiber") {
            if ($loadedOnu->fiber->parent_component_type === "onu" && $loadedOnu->fiber->parent_component_id === $loadedOnu->id) {
                $loadedOnu->fiber->parent_component_type = null;
                $loadedOnu->fiber->parent_component_id = null;
                $loadedOnu->fiber->save();
            } else if ($loadedOnu->fiber->child_component_type === "onu" && $loadedOnu->fiber->child_component_id === $loadedOnu->id) {
                $loadedOnu->fiber->child_component_type = null;
                $loadedOnu->fiber->child_component_id = null;
                $loadedOnu->fiber->save();
            } else {
                return response()->json(["message" => "Fiber not connected to this onu"], 400);
            }

            $loadedOnu->fiber_id = null;
            $loadedOnu->cable_id = null;
        }

        $loadedOnu->save();

        return [
            "message" => "Onu disconnected successfully"
        ];
    }
}
