<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithTitle;
use Illuminate\Support\Collection;
use Carbon\Carbon;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use Maatwebsite\Excel\Concerns\WithDrawings;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;


class BandPurchaseExport implements FromCollection, WithHeadings, WithDrawings
{
    protected $data;
    protected $imageCoordinates = [];

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function headings(): array
    {
        return [
            'SL',
            'Invoice',
            // 'Document',
            'Provider',
            'Billing Date',
            'Service',
            'Qty',
            'Rate',
            'VAT',
            'From',
            'To',
            'Line Total',
            'Total',
            'Paid',
            'Due',
        ];
    }

    public function collection()
    {
        $rows = [];
        $sl = 1;
        $grandTotal = 0;
        $grandPaid = 0;
        $grandDue = 0;
        $rowIndex = 2; // Starting after the header row

        foreach ($this->data as $purchase) {
            $total = $purchase->total_price;
            $paid = $purchase->paid;
            $due = $total - $paid;

            $grandTotal += $total;
            $grandPaid += $paid;
            $grandDue += $due;

            // $documentPath = public_path('storage/bandPurchase/' . $purchase->document);
            // if ($purchase->document && file_exists($documentPath)) {
            //     $this->imageCoordinates[] = [
            //         'path' => $documentPath,
            //         'cell' => 'C' . $rowIndex, // Column C for image
            //     ];
            // }

            // Invoice Header Row
            $rows[] = [
                $sl++,
                $purchase->invoice_no,
                // '',
                $purchase->provider->company_name ?? '',
                Carbon::parse($purchase->billing_date)->format('d-M-Y'),
                '',
                '',
                '',
                '',
                '',
                '',
                '',
                number_format($total, 2),
                number_format($paid, 2),
                number_format($due, 2)
            ];
            $rowIndex++; // Increment row index after each row

            // Service Rows
            foreach ($purchase->purchaseItem as $item) {
                $rows[] = [
                    '',
                    '',
                    '',
                    '',
                    $item->service->name ?? '',
                    $item->quantity ?? '',
                    $item->rate ?? '',
                    $item->vat ?? '',
                    Carbon::parse($item->from_date)->format('d-M-Y'),
                    Carbon::parse($item->to_date)->format('d-M-Y'),
                    number_format($item->line_total, 2),
                    '',
                    '',
                    '',
                ];
                $rowIndex++; // count service row
            }

            // Optional: blank row between invoices
            $rows[] = ['', '', '', '', '', '', '', '', '', '', '', '', '', ''];
            $rowIndex++; // count blank row
        }

        // Add Grand Total Row
        $rows[] = [
            '',
            '',
            // '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            'Total',
            number_format($grandTotal, 2),
            number_format($grandPaid, 2),
            number_format($grandDue, 2)
        ];

        return collect($rows);
    }

    public function drawings()
    {
        $drawings = [];

        foreach ($this->imageCoordinates as $img) {
            $drawing = new Drawing();
            $drawing->setName('Document');
            $drawing->setDescription('Purchase Document');
            $drawing->setPath($img['path']);
            $drawing->setHeight(20);
            $drawing->setCoordinates($img['cell']);
            $drawings[] = $drawing;
        }

        return $drawings;
    }
}
