<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Area;
use App\Models\Client;
use App\Models\CustomerAccount;
use App\Models\Pop;
use App\Models\Reseller;
use App\Models\ResellerArea;
use Brian2694\Toastr\Facades\Toastr;

class AdvencedBalencedCustomerController extends Controller
{
    public function advancedBalancedCustomer()
    {
        $resellers = Reseller::list()->where('reseller_type', 'own');
        $data=[
            'resellers' => $resellers,
            'confday' => config('app.billing_cycle'),
        ];

        return view('clients.haveAdvancedBlance.index', $data);
    }

    public function advancedBalancedCustomerSearch(Request $request)
    {
        // $clients = Client::with('packages','pop','clientsinfo','customerAccount')->get();

        $due_customer_list = CustomerAccount::where('dueAmount', '<', 0);
        
        if($request->reseller == "all"){
            $resellers = Reseller::list()->where('reseller_type', 'own');
        }else{
            $resellers = Reseller::list()->where('id', $request->reseller);
        }
        if($request->pop == "all"){
            $popes = Pop::whereIn('reseller_id', $resellers->pluck('id'))->get();
            $clients = Client::with('packages','pop','clientsinfo','customerAccount','subpack')->whereIn('pop_id', $popes->pluck('id'))->whereIn('id',$due_customer_list->pluck('client_id'));
        }else{
            $popes = Pop::where('id',$request->pop)->get();
            $clients = Client::with('packages','pop','clientsinfo','customerAccount','subpack')->whereIn('pop_id', $popes->pluck('id'))->whereIn('id',$due_customer_list->pluck('client_id'));
        }


        if($request->billing_cycle != "all"){
            $clients = $clients->where('billing_cycle', $request->billing_cycle);
        }else{
            $clients = $clients;
        }


        // $clients = $clients->whereIn('id', $due_customer_list->pluck('client_id'))->get();
        $mother_packge_permissin = false;
        if (auth()->user()->hasPermissionTo('show-mother-package')) {
            $mother_packge_permissin = true;
        }

        $sub_package_permission = false;
        if(auth()->user()->hasPermissionTo('show-sub-package')){
            $sub_package_permission = true;
        }
        $new_clients = [];
        if(in_array("all",$request->area) || $request->area == null){
            // foreach($clients as $client){
            //     if($client->clientsinfo->area == $request->area){
            //         $new_clients[] = $client;
            //     }
            // }
            $new_clients = $clients->get();
        }else{
            $new_clients = $clients->whereHas('clientsinfo', function($q) use($request){
                $q->whereIn('area', $request->area);
            })->get();
        }


        $data=[
            'clients' => $new_clients,
            'areas' => $request->area,
            'sub_package_permission' => $sub_package_permission,
            'mother_packge_permissin' => $mother_packge_permissin,
        ];

        return $data;

    }


    public function changeBillingCurrentMounth()
    {
        $clients = Client::get();
        foreach($clients as $client){
            $client->expire_date = date('Y-m-' . $client->billing_cycle . ' 00:00:00');
            $client->clients_status = 'active';
            $client->save();
        }
        Toastr::success('Expired date change to current Changed Successfully', 'Success');
        return back();
    }

    public function changeBillingCurrentMounthWithOutStatus()
    {
        $clients = Client::get();
        foreach($clients as $client){
            $client->expire_date = date('Y-m-' . $client->billing_cycle . ' 00:00:00');
            $client->save();
        }
        Toastr::success('Expired date change to current Changed Successfully', 'Success');
        return back();
    }

    public function deleteAllAccount()
    {

    }


}
